/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.nimbusds.openid.connect.sdk.federation.entities;

import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.ParseException;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.as.AuthorizationServerMetadata;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.client.ClientMetadata;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.util.JSONArrayUtils;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.dataiku.dss.shadelibazure.com.nimbusds.openid.connect.sdk.claims.CommonClaimsSet;
import com.dataiku.dss.shadelibazure.com.nimbusds.openid.connect.sdk.federation.entities.EntityID;
import com.dataiku.dss.shadelibazure.com.nimbusds.openid.connect.sdk.federation.entities.EntityType;
import com.dataiku.dss.shadelibazure.com.nimbusds.openid.connect.sdk.federation.entities.FederationEntityMetadata;
import com.dataiku.dss.shadelibazure.com.nimbusds.openid.connect.sdk.federation.trust.marks.TrustMarkEntry;
import com.dataiku.dss.shadelibazure.com.nimbusds.openid.connect.sdk.federation.trust.marks.TrustMarkIssuerMetadata;
import com.dataiku.dss.shadelibazure.com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import com.dataiku.dss.shadelibazure.com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import com.dataiku.dss.shadelibazure.net.minidev.json.JSONArray;
import com.dataiku.dss.shadelibazure.net.minidev.json.JSONObject;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public abstract class CommonFederationClaimsSet
extends CommonClaimsSet {
    public static final String EXP_CLAIM_NAME = "exp";
    public static final String METADATA_CLAIM_NAME = "metadata";
    public static final String TRUST_MARKS_CLAIM_NAME = "trust_marks";

    protected CommonFederationClaimsSet() {
    }

    protected CommonFederationClaimsSet(JSONObject jsonObject) {
        super(jsonObject);
    }

    protected void validateRequiredClaimsPresence() throws ParseException {
        if (this.getIssuer() == null) {
            throw new ParseException("Missing iss (issuer) claim");
        }
        EntityID.parse(this.getIssuer());
        if (this.getSubject() == null) {
            throw new ParseException("Missing sub (subject) claim");
        }
        EntityID.parse(this.getSubject());
        if (this.getIssueTime() == null) {
            throw new ParseException("Missing iat (issued-at) claim");
        }
        if (this.getExpirationTime() == null) {
            throw new ParseException("Missing exp (expiration) claim");
        }
    }

    public EntityID getIssuerEntityID() {
        return new EntityID(this.getIssuer().getValue());
    }

    public EntityID getSubjectEntityID() {
        return new EntityID(this.getSubject().getValue());
    }

    public Date getExpirationTime() {
        return this.getDateClaim(EXP_CLAIM_NAME);
    }

    public JSONObject getMetadata(EntityType type) {
        JSONObject o = this.getJSONObjectClaim(METADATA_CLAIM_NAME);
        if (o == null) {
            return null;
        }
        try {
            return JSONObjectUtils.getJSONObject(o, type.getValue(), null);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public void setMetadata(EntityType type, JSONObject metadata) {
        JSONObject o = this.getJSONObjectClaim(METADATA_CLAIM_NAME);
        if (o == null) {
            if (metadata == null) {
                return;
            }
            o = new JSONObject();
        }
        o.put(type.getValue(), metadata);
        this.setClaim(METADATA_CLAIM_NAME, o);
    }

    public OIDCClientMetadata getRPMetadata() {
        JSONObject o = this.getMetadata(EntityType.OPENID_RELYING_PARTY);
        if (o == null) {
            return null;
        }
        try {
            return OIDCClientMetadata.parse(o);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public void setRPMetadata(OIDCClientMetadata rpMetadata) {
        JSONObject o = rpMetadata != null ? rpMetadata.toJSONObject() : null;
        this.setMetadata(EntityType.OPENID_RELYING_PARTY, o);
    }

    public OIDCProviderMetadata getOPMetadata() {
        JSONObject o = this.getMetadata(EntityType.OPENID_PROVIDER);
        if (o == null) {
            return null;
        }
        try {
            return OIDCProviderMetadata.parse(o);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public void setOPMetadata(OIDCProviderMetadata opMetadata) {
        JSONObject o = opMetadata != null ? opMetadata.toJSONObject() : null;
        this.setMetadata(EntityType.OPENID_PROVIDER, o);
    }

    public ClientMetadata getOAuthClientMetadata() {
        JSONObject o = this.getMetadata(EntityType.OAUTH_CLIENT);
        if (o == null) {
            return null;
        }
        try {
            return ClientMetadata.parse(o);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public void setOAuthClientMetadata(ClientMetadata clientMetadata) {
        JSONObject o = clientMetadata != null ? clientMetadata.toJSONObject() : null;
        this.setMetadata(EntityType.OAUTH_CLIENT, o);
    }

    public AuthorizationServerMetadata getASMetadata() {
        JSONObject o = this.getMetadata(EntityType.OAUTH_AUTHORIZATION_SERVER);
        if (o == null) {
            return null;
        }
        try {
            return AuthorizationServerMetadata.parse(o);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public void setASMetadata(AuthorizationServerMetadata asMetadata) {
        JSONObject o = asMetadata != null ? asMetadata.toJSONObject() : null;
        this.setMetadata(EntityType.OAUTH_AUTHORIZATION_SERVER, o);
    }

    public FederationEntityMetadata getFederationEntityMetadata() {
        JSONObject o = this.getMetadata(EntityType.FEDERATION_ENTITY);
        if (o == null) {
            return null;
        }
        try {
            return FederationEntityMetadata.parse(o);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public void setFederationEntityMetadata(FederationEntityMetadata entityMetadata) {
        JSONObject o = entityMetadata != null ? entityMetadata.toJSONObject() : null;
        this.setMetadata(EntityType.FEDERATION_ENTITY, o);
    }

    @Deprecated
    public TrustMarkIssuerMetadata getTrustMarkIssuerMetadata() {
        JSONObject o = this.getMetadata(EntityType.TRUST_MARK_ISSUER);
        if (o == null) {
            return null;
        }
        try {
            return TrustMarkIssuerMetadata.parse(o);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public List<TrustMarkEntry> getTrustMarks() {
        List<JSONObject> jsonObjects;
        JSONArray array = this.getJSONArrayClaim(TRUST_MARKS_CLAIM_NAME);
        if (array == null) {
            return null;
        }
        try {
            jsonObjects = JSONArrayUtils.toJSONObjectList(array);
        }
        catch (ParseException e) {
            return null;
        }
        LinkedList<TrustMarkEntry> marks = new LinkedList<TrustMarkEntry>();
        for (JSONObject o : jsonObjects) {
            try {
                marks.add(TrustMarkEntry.parse(o));
            }
            catch (ParseException e) {
                return null;
            }
        }
        return marks;
    }

    public void setTrustMarks(List<TrustMarkEntry> marks) {
        if (marks != null) {
            JSONArray array = new JSONArray();
            for (TrustMarkEntry en : marks) {
                array.add(en.toJSONObject());
            }
            this.setClaim(TRUST_MARKS_CLAIM_NAME, array);
        } else {
            this.setClaim(TRUST_MARKS_CLAIM_NAME, null);
        }
    }
}

