/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.core.publisher;

import com.dataiku.dss.shadelibazure.org.reactivestreams.Publisher;
import com.dataiku.dss.shadelibazure.org.reactivestreams.Subscriber;
import com.dataiku.dss.shadelibazure.reactor.core.CorePublisher;
import com.dataiku.dss.shadelibazure.reactor.core.CoreSubscriber;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.FluxContextWrite;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Operators;
import com.dataiku.dss.shadelibazure.reactor.util.context.Context;
import java.util.function.Function;

class ContextTrackingFunctionWrapper<T, V>
implements Function<Publisher<T>, CorePublisher<V>> {
    static final String CONTEXT_MARKER_PREFIX = "com.dataiku.dss.shadelibazure.reactor.core.context.marker.";
    final Function<? super Publisher<T>, ? extends Publisher<V>> transformer;
    final String marker;

    ContextTrackingFunctionWrapper(Function<? super Publisher<T>, ? extends Publisher<V>> transformer) {
        this(transformer, transformer.toString());
    }

    ContextTrackingFunctionWrapper(Function<? super Publisher<T>, ? extends Publisher<V>> transformer, String marker) {
        this.transformer = transformer;
        this.marker = marker;
    }

    @Override
    public CorePublisher<V> apply(Publisher<T> source2) {
        final String key = CONTEXT_MARKER_PREFIX + System.identityHashCode(source2);
        source2 = Operators.liftPublisher((p, actual) -> {
            Context ctx = actual.currentContext();
            if (!ctx.hasKey(key)) {
                throw new IllegalStateException("Context loss after applying " + this.marker);
            }
            Context newContext = ctx.delete(key);
            return new FluxContextWrite.ContextWriteSubscriber(actual, newContext);
        }).apply(source2);
        final Publisher<V> result = this.transformer.apply(source2);
        return new CorePublisher<V>(){

            @Override
            public void subscribe(CoreSubscriber<? super V> actual) {
                Context ctx = actual.currentContext().put(key, true);
                FluxContextWrite.ContextWriteSubscriber subscriber = new FluxContextWrite.ContextWriteSubscriber(actual, ctx);
                if (result instanceof CorePublisher) {
                    ((CorePublisher)result).subscribe(subscriber);
                } else {
                    result.subscribe(subscriber);
                }
            }

            @Override
            public void subscribe(Subscriber<? super V> subscriber) {
                this.subscribe(Operators.toCoreSubscriber(subscriber));
            }
        };
    }
}

