/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.core.publisher;

import com.dataiku.dss.shadelibazure.reactor.core.CoreSubscriber;
import com.dataiku.dss.shadelibazure.reactor.core.Fuseable;
import com.dataiku.dss.shadelibazure.reactor.core.Scannable;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.InternalMonoOperator;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.MonoNameFuseable;
import com.dataiku.dss.shadelibazure.reactor.util.annotation.Nullable;
import com.dataiku.dss.shadelibazure.reactor.util.function.Tuple2;
import com.dataiku.dss.shadelibazure.reactor.util.function.Tuples;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

final class MonoName<T>
extends InternalMonoOperator<T, T> {
    final String name;
    final Set<Tuple2<String, String>> tags;

    static <T> Mono<T> createOrAppend(Mono<T> source2, String name) {
        Objects.requireNonNull(name, "name");
        if (source2 instanceof MonoName) {
            MonoName s2 = (MonoName)source2;
            return new MonoName<T>(s2.source, name, s2.tags);
        }
        if (source2 instanceof MonoNameFuseable) {
            MonoNameFuseable s3 = (MonoNameFuseable)source2;
            return new MonoNameFuseable(s3.source, name, s3.tags);
        }
        if (source2 instanceof Fuseable) {
            return new MonoNameFuseable<T>(source2, name, null);
        }
        return new MonoName<T>(source2, name, null);
    }

    static <T> Mono<T> createOrAppend(Mono<T> source2, String tagName, String tagValue) {
        Objects.requireNonNull(tagName, "tagName");
        Objects.requireNonNull(tagValue, "tagValue");
        Set<Tuple2<String, String>> tags = Collections.singleton(Tuples.of(tagName, tagValue));
        if (source2 instanceof MonoName) {
            MonoName s2 = (MonoName)source2;
            if (s2.tags != null) {
                tags = new HashSet<Tuple2<String, String>>(tags);
                tags.addAll(s2.tags);
            }
            return new MonoName<T>(s2.source, s2.name, tags);
        }
        if (source2 instanceof MonoNameFuseable) {
            MonoNameFuseable s3 = (MonoNameFuseable)source2;
            if (s3.tags != null) {
                tags = new HashSet<Tuple2<String, String>>(tags);
                tags.addAll(s3.tags);
            }
            return new MonoNameFuseable(s3.source, s3.name, tags);
        }
        if (source2 instanceof Fuseable) {
            return new MonoNameFuseable<T>(source2, null, tags);
        }
        return new MonoName<T>(source2, null, tags);
    }

    MonoName(Mono<? extends T> source2, @Nullable String name, @Nullable Set<Tuple2<String, String>> tags) {
        super(source2);
        this.name = name;
        this.tags = tags;
    }

    @Override
    public CoreSubscriber<? super T> subscribeOrReturn(CoreSubscriber<? super T> actual) {
        return actual;
    }

    @Override
    @Nullable
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.NAME) {
            return this.name;
        }
        if (key == Scannable.Attr.TAGS && this.tags != null) {
            return this.tags.stream();
        }
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        return super.scanUnsafe(key);
    }
}

