/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.core.publisher;

import com.dataiku.dss.shadelibazure.org.reactivestreams.Subscription;
import com.dataiku.dss.shadelibazure.reactor.core.CoreSubscriber;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Operators;
import com.dataiku.dss.shadelibazure.reactor.util.context.Context;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;

final class MonoToCompletableFuture<T>
extends CompletableFuture<T>
implements CoreSubscriber<T> {
    final AtomicReference<Subscription> ref = new AtomicReference();
    final boolean cancelSourceOnNext;

    MonoToCompletableFuture(boolean sourceCanEmitMoreThanOnce) {
        this.cancelSourceOnNext = sourceCanEmitMoreThanOnce;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        Subscription s2;
        boolean cancelled = super.cancel(mayInterruptIfRunning);
        if (cancelled && (s2 = (Subscription)this.ref.getAndSet(null)) != null) {
            s2.cancel();
        }
        return cancelled;
    }

    @Override
    public void onSubscribe(Subscription s2) {
        if (Operators.validate(this.ref.getAndSet(s2), s2)) {
            s2.request(Long.MAX_VALUE);
        } else {
            s2.cancel();
        }
    }

    @Override
    public void onNext(T t) {
        Subscription s2 = this.ref.getAndSet(null);
        if (s2 != null) {
            this.complete(t);
            if (this.cancelSourceOnNext) {
                s2.cancel();
            }
        } else {
            Operators.onNextDropped(t, this.currentContext());
        }
    }

    @Override
    public void onError(Throwable t) {
        if (this.ref.getAndSet(null) != null) {
            this.completeExceptionally(t);
        }
    }

    @Override
    public void onComplete() {
        if (this.ref.getAndSet(null) != null) {
            this.complete(null);
        }
    }

    @Override
    public Context currentContext() {
        return Context.empty();
    }
}

