/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.netty.http.client;

import com.dataiku.dss.shadelibazure.io.micrometer.core.instrument.Timer;
import com.dataiku.dss.shadelibazure.reactor.netty.Metrics;
import com.dataiku.dss.shadelibazure.reactor.netty.channel.MeterKey;
import com.dataiku.dss.shadelibazure.reactor.netty.http.MicrometerHttpMetricsRecorder;
import com.dataiku.dss.shadelibazure.reactor.netty.http.client.HttpClientMetricsRecorder;
import com.dataiku.dss.shadelibazure.reactor.netty.internal.util.MapUtils;
import java.net.SocketAddress;
import java.time.Duration;

final class MicrometerHttpClientMetricsRecorder
extends MicrometerHttpMetricsRecorder
implements HttpClientMetricsRecorder {
    static final MicrometerHttpClientMetricsRecorder INSTANCE = new MicrometerHttpClientMetricsRecorder();

    private MicrometerHttpClientMetricsRecorder() {
        super("com.dataiku.dss.shadelibazure.reactor.netty.http.client", "http");
    }

    @Override
    public void recordDataReceivedTime(SocketAddress remoteAddress, String uri, String method, String status, Duration time) {
        String address = Metrics.formatSocketAddress(remoteAddress);
        MeterKey meterKey = new MeterKey(uri, address, method, status);
        Timer dataReceivedTime = MapUtils.computeIfAbsent(this.dataReceivedTimeCache, meterKey, key -> MicrometerHttpClientMetricsRecorder.filter(Timer.builder((String)(this.name() + ".data.received.time")).description("Time spent in consuming incoming data").tags(new String[]{"remote.address", address, "uri", uri, "method", method, "status", status}).register(Metrics.REGISTRY)));
        if (dataReceivedTime != null) {
            dataReceivedTime.record(time);
        }
    }

    @Override
    public void recordDataSentTime(SocketAddress remoteAddress, String uri, String method, Duration time) {
        String address = Metrics.formatSocketAddress(remoteAddress);
        MeterKey meterKey = new MeterKey(uri, address, method, null);
        Timer dataSentTime = MapUtils.computeIfAbsent(this.dataSentTimeCache, meterKey, key -> MicrometerHttpClientMetricsRecorder.filter(Timer.builder((String)(this.name() + ".data.sent.time")).description("Time spent in sending outgoing data").tags(new String[]{"remote.address", address, "uri", uri, "method", method}).register(Metrics.REGISTRY)));
        if (dataSentTime != null) {
            dataSentTime.record(time);
        }
    }

    @Override
    public void recordResponseTime(SocketAddress remoteAddress, String uri, String method, String status, Duration time) {
        String address = Metrics.formatSocketAddress(remoteAddress);
        MeterKey meterKey = new MeterKey(uri, address, method, status);
        Timer responseTime = MapUtils.computeIfAbsent(this.responseTimeCache, meterKey, key -> MicrometerHttpClientMetricsRecorder.filter(Timer.builder((String)(this.name() + ".response.time")).description("Total time for the request/response").tags(new String[]{"remote.address", address, "uri", uri, "method", method, "status", status}).register(Metrics.REGISTRY)));
        if (responseTime != null) {
            responseTime.record(time);
        }
    }
}

