/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.netty.http.server;

import com.dataiku.dss.shadelibazure.io.netty.buffer.ByteBuf;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelDuplexHandler;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelFuture;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelFutureListener;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelHandlerContext;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelPromise;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.DecoderResult;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.DefaultHttpContent;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.HttpObject;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.HttpRequest;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.HttpResponse;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.HttpResponseStatus;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.LastHttpContent;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import com.dataiku.dss.shadelibazure.io.netty.handler.ssl.SslHandler;
import com.dataiku.dss.shadelibazure.io.netty.util.ReferenceCountUtil;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import com.dataiku.dss.shadelibazure.reactor.netty.Connection;
import com.dataiku.dss.shadelibazure.reactor.netty.ConnectionObserver;
import com.dataiku.dss.shadelibazure.reactor.netty.ReactorNetty;
import com.dataiku.dss.shadelibazure.reactor.netty.http.logging.HttpMessageArgProviderFactory;
import com.dataiku.dss.shadelibazure.reactor.netty.http.logging.HttpMessageLogFactory;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.ConnectionInfo;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.HAProxyMessageReader;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.HttpServerFormDecoderProvider;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.HttpServerOperations;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.HttpServerRequest;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.HttpServerResponse;
import com.dataiku.dss.shadelibazure.reactor.util.annotation.Nullable;
import java.net.SocketAddress;
import java.time.ZonedDateTime;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;

final class Http2StreamBridgeServerHandler
extends ChannelDuplexHandler
implements ChannelFutureListener {
    final BiPredicate<HttpServerRequest, HttpServerResponse> compress;
    final ServerCookieDecoder cookieDecoder;
    final ServerCookieEncoder cookieEncoder;
    final HttpServerFormDecoderProvider formDecoderProvider;
    final BiFunction<ConnectionInfo, HttpRequest, ConnectionInfo> forwardedHeaderHandler;
    final HttpMessageLogFactory httpMessageLogFactory;
    final ConnectionObserver listener;
    final BiFunction<? super Mono<Void>, ? super Connection, ? extends Mono<Void>> mapHandle;
    SocketAddress remoteAddress;
    Boolean secured;
    boolean pendingResponse;

    Http2StreamBridgeServerHandler(@Nullable BiPredicate<HttpServerRequest, HttpServerResponse> compress, ServerCookieDecoder decoder, ServerCookieEncoder encoder, HttpServerFormDecoderProvider formDecoderProvider, @Nullable BiFunction<ConnectionInfo, HttpRequest, ConnectionInfo> forwardedHeaderHandler, HttpMessageLogFactory httpMessageLogFactory, ConnectionObserver listener, @Nullable BiFunction<? super Mono<Void>, ? super Connection, ? extends Mono<Void>> mapHandle) {
        this.compress = compress;
        this.cookieDecoder = decoder;
        this.cookieEncoder = encoder;
        this.formDecoderProvider = formDecoderProvider;
        this.forwardedHeaderHandler = forwardedHeaderHandler;
        this.httpMessageLogFactory = httpMessageLogFactory;
        this.listener = listener;
        this.mapHandle = mapHandle;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) {
        if (HttpServerOperations.log.isDebugEnabled()) {
            HttpServerOperations.log.debug(ReactorNetty.format(ctx.channel(), "New HTTP/2 stream"));
        }
        ctx.read();
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (this.secured == null) {
            this.secured = ctx.channel().parent().pipeline().get(SslHandler.class) != null;
        }
        if (this.remoteAddress == null) {
            this.remoteAddress = Optional.ofNullable(HAProxyMessageReader.resolveRemoteAddressFromProxyProtocol(ctx.channel().parent())).orElse(ctx.channel().parent().remoteAddress());
        }
        if (msg instanceof HttpRequest) {
            HttpServerOperations ops;
            HttpRequest request = (HttpRequest)msg;
            ZonedDateTime timestamp = ZonedDateTime.now(ReactorNetty.ZONE_ID_SYSTEM);
            ConnectionInfo connectionInfo = null;
            try {
                this.pendingResponse = true;
                connectionInfo = ConnectionInfo.from(ctx.channel(), request, this.secured, this.remoteAddress, this.forwardedHeaderHandler);
                ops = new HttpServerOperations(Connection.from(ctx.channel()), this.listener, request, this.compress, connectionInfo, this.cookieDecoder, this.cookieEncoder, this.formDecoderProvider, this.httpMessageLogFactory, true, this.mapHandle, this.secured, timestamp);
            }
            catch (RuntimeException e) {
                this.pendingResponse = false;
                request.setDecoderResult(DecoderResult.failure(e.getCause() != null ? e.getCause() : e));
                HttpServerOperations.sendDecodingFailures(ctx, this.listener, this.secured, e, msg, this.httpMessageLogFactory, true, timestamp, connectionInfo, this.remoteAddress);
                return;
            }
            ops.bind();
            this.listener.onStateChange(ops, ConnectionObserver.State.CONFIGURED);
        } else if (!this.pendingResponse) {
            if (HttpServerOperations.log.isDebugEnabled()) {
                HttpServerOperations.log.debug(ReactorNetty.format(ctx.channel(), "Dropped HTTP content, since response has been sent already: {}"), msg instanceof HttpObject ? this.httpMessageLogFactory.debug(HttpMessageArgProviderFactory.create(msg)) : msg);
            }
            ReferenceCountUtil.release(msg);
            ctx.read();
            return;
        }
        ctx.fireChannelRead(msg);
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (msg instanceof ByteBuf) {
            if (!this.pendingResponse) {
                if (HttpServerOperations.log.isDebugEnabled()) {
                    HttpServerOperations.log.debug(ReactorNetty.format(ctx.channel(), "Dropped HTTP content, since response has been sent already: {}"), msg);
                }
                ((ByteBuf)msg).release();
                promise.setSuccess();
                return;
            }
            ctx.write(new DefaultHttpContent((ByteBuf)msg), promise);
        } else if (msg instanceof HttpResponse && HttpResponseStatus.CONTINUE.equals(((HttpResponse)msg).status())) {
            ctx.write(msg, promise);
        } else {
            ChannelFuture f = ctx.write(msg, promise);
            if (msg instanceof LastHttpContent) {
                this.pendingResponse = false;
                f.addListener(this);
                ctx.read();
            }
        }
    }

    @Override
    public void operationComplete(ChannelFuture future) {
        if (!future.isSuccess()) {
            if (HttpServerOperations.log.isDebugEnabled()) {
                HttpServerOperations.log.debug(ReactorNetty.format(future.channel(), "Sending last HTTP packet was not successful, terminating the channel"), future.cause());
            }
        } else if (HttpServerOperations.log.isDebugEnabled()) {
            HttpServerOperations.log.debug(ReactorNetty.format(future.channel(), "Last HTTP packet was sent, terminating the channel"));
        }
        HttpServerOperations.cleanHandlerTerminate(future.channel());
    }
}

