/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.netty.internal.shaded.reactor.pool;

import com.dataiku.dss.shadelibazure.org.reactivestreams.Publisher;
import com.dataiku.dss.shadelibazure.org.reactivestreams.Subscription;
import com.dataiku.dss.shadelibazure.reactor.core.CoreSubscriber;
import com.dataiku.dss.shadelibazure.reactor.core.Disposable;
import com.dataiku.dss.shadelibazure.reactor.core.Disposables;
import com.dataiku.dss.shadelibazure.reactor.core.Scannable;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Operators;
import com.dataiku.dss.shadelibazure.reactor.netty.internal.shaded.reactor.pool.InstrumentedPool;
import com.dataiku.dss.shadelibazure.reactor.netty.internal.shaded.reactor.pool.PoolAcquireTimeoutException;
import com.dataiku.dss.shadelibazure.reactor.netty.internal.shaded.reactor.pool.PoolBuilder;
import com.dataiku.dss.shadelibazure.reactor.netty.internal.shaded.reactor.pool.PoolConfig;
import com.dataiku.dss.shadelibazure.reactor.netty.internal.shaded.reactor.pool.PoolMetricsRecorder;
import com.dataiku.dss.shadelibazure.reactor.netty.internal.shaded.reactor.pool.PooledRef;
import com.dataiku.dss.shadelibazure.reactor.netty.internal.shaded.reactor.pool.PooledRefMetadata;
import com.dataiku.dss.shadelibazure.reactor.util.Logger;
import com.dataiku.dss.shadelibazure.reactor.util.annotation.Nullable;
import com.dataiku.dss.shadelibazure.reactor.util.context.Context;
import java.io.Closeable;
import java.io.IOException;
import java.time.Clock;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.Function;

abstract class AbstractPool<POOLABLE>
implements InstrumentedPool<POOLABLE>,
InstrumentedPool.PoolMetrics {
    final Logger logger;
    final PoolConfig<POOLABLE> poolConfig;
    final PoolMetricsRecorder metricsRecorder;
    final Clock clock;
    long lastInteractionTimestamp;

    AbstractPool(PoolConfig<POOLABLE> poolConfig, Logger logger) {
        this.poolConfig = poolConfig;
        this.logger = logger;
        this.metricsRecorder = poolConfig.metricsRecorder();
        this.clock = poolConfig.clock();
        this.lastInteractionTimestamp = this.clock.millis();
    }

    @Override
    public PoolConfig<POOLABLE> config() {
        return this.poolConfig;
    }

    @Override
    public InstrumentedPool.PoolMetrics metrics() {
        return this;
    }

    @Override
    public int allocatedSize() {
        return this.poolConfig.allocationStrategy().permitGranted();
    }

    @Override
    public abstract int idleSize();

    @Override
    public int acquiredSize() {
        return this.allocatedSize() - this.idleSize();
    }

    @Override
    public int getMaxAllocatedSize() {
        return this.poolConfig.allocationStrategy().permitMaximum();
    }

    @Override
    public int getMaxPendingAcquireSize() {
        return this.poolConfig.maxPending() < 0 ? Integer.MAX_VALUE : this.poolConfig.maxPending();
    }

    void recordInteractionTimestamp() {
        this.lastInteractionTimestamp = this.clock.millis();
    }

    @Override
    public long secondsSinceLastInteraction() {
        long sinceMs = this.clock.millis() - this.lastInteractionTimestamp;
        return sinceMs / 1000L;
    }

    @Override
    public boolean isInactiveForMoreThan(Duration duration) {
        return this.idleSize() == 0 && this.pendingAcquireSize() == 0 && this.allocatedSize() == 0 && this.secondsSinceLastInteraction() >= duration.getSeconds();
    }

    abstract boolean elementOffer(POOLABLE var1);

    abstract void doAcquire(Borrower<POOLABLE> var1);

    abstract void cancelAcquire(Borrower<POOLABLE> var1);

    private void defaultDestroy(@Nullable POOLABLE poolable) {
        if (poolable instanceof Disposable) {
            ((Disposable)poolable).dispose();
        } else if (poolable instanceof Closeable) {
            try {
                ((Closeable)poolable).close();
            }
            catch (IOException e) {
                this.logger.trace("Failure while discarding a released Poolable that is Closeable, could not close", e);
            }
        }
    }

    Mono<Void> destroyPoolable(AbstractPooledRef<POOLABLE> ref) {
        Mono<Object> userProvidedDestroy;
        if (ref.state != 3) {
            throw new IllegalStateException("destroying non invalidated ref " + ref);
        }
        POOLABLE poolable = ref.poolable();
        this.poolConfig.allocationStrategy().returnPermits(1);
        long start = this.clock.millis();
        this.metricsRecorder.recordLifetimeDuration(ref.lifeTime());
        Function<POOLABLE, Publisher<Void>> factory2 = this.poolConfig.destroyHandler();
        if (factory2 == PoolBuilder.NOOP_HANDLER) {
            return Mono.fromRunnable(() -> {
                this.defaultDestroy(poolable);
                this.metricsRecorder.recordDestroyLatency(this.clock.millis() - start);
            });
        }
        try {
            userProvidedDestroy = Mono.from(factory2.apply(poolable));
        }
        catch (Throwable destroyFunctionError) {
            userProvidedDestroy = Mono.error(destroyFunctionError);
        }
        return userProvidedDestroy.doFinally(fin -> this.metricsRecorder.recordDestroyLatency(this.clock.millis() - start));
    }

    static final class Borrower<POOLABLE>
    extends AtomicBoolean
    implements Scannable,
    Subscription,
    Runnable {
        static final Disposable TIMEOUT_DISPOSED = Disposables.disposed();
        final CoreSubscriber<? super AbstractPooledRef<POOLABLE>> actual;
        final AbstractPool<POOLABLE> pool;
        final Duration pendingAcquireTimeout;
        Disposable timeoutTask;

        Borrower(CoreSubscriber<? super AbstractPooledRef<POOLABLE>> actual, AbstractPool<POOLABLE> pool, Duration pendingAcquireTimeout) {
            this.actual = actual;
            this.pool = pool;
            this.pendingAcquireTimeout = pendingAcquireTimeout;
            this.timeoutTask = TIMEOUT_DISPOSED;
        }

        Context currentContext() {
            return this.actual.currentContext();
        }

        @Override
        public void run() {
            if (this.compareAndSet(false, true)) {
                this.pool.cancelAcquire(this);
                this.actual.onError(new PoolAcquireTimeoutException(this.pendingAcquireTimeout));
            }
        }

        @Override
        public void request(long n) {
            if (Operators.validate(n)) {
                boolean noPermits;
                boolean noIdle = this.pool.idleSize() == 0;
                boolean bl = noPermits = this.pool.poolConfig.allocationStrategy().estimatePermitCount() == 0;
                if (!this.pendingAcquireTimeout.isZero() && noIdle && noPermits) {
                    this.timeoutTask = this.pool.config().pendingAcquireTimer().apply(this, this.pendingAcquireTimeout);
                }
                this.pool.doAcquire(this);
            }
        }

        void stopPendingCountdown() {
            this.timeoutTask.dispose();
        }

        @Override
        public void cancel() {
            this.set(true);
            this.pool.cancelAcquire(this);
            this.stopPendingCountdown();
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.CANCELLED) {
                return this.get();
            }
            if (key == Scannable.Attr.REQUESTED_FROM_DOWNSTREAM) {
                return 1;
            }
            if (key == Scannable.Attr.ACTUAL) {
                return this.actual;
            }
            return null;
        }

        void deliver(AbstractPooledRef<POOLABLE> poolSlot) {
            this.stopPendingCountdown();
            if (this.get()) {
                poolSlot.release().subscribe(aVoid -> {}, e -> Operators.onErrorDropped(e, Context.empty()));
            } else {
                poolSlot.markAcquired();
                this.actual.onNext(poolSlot);
                this.actual.onComplete();
            }
        }

        void fail(Throwable error) {
            this.stopPendingCountdown();
            if (!this.get()) {
                this.actual.onError(error);
            }
        }

        @Override
        public String toString() {
            return this.get() ? "Borrower(cancelled)" : "Borrower";
        }
    }

    static abstract class AbstractPooledRef<T>
    implements PooledRef<T>,
    PooledRefMetadata {
        final long creationTimestamp;
        final PoolMetricsRecorder metricsRecorder;
        final Clock clock;
        final T poolable;
        final int acquireCount;
        long releaseTimestamp;
        volatile int state;
        static final AtomicIntegerFieldUpdater<AbstractPooledRef> STATE = AtomicIntegerFieldUpdater.newUpdater(AbstractPooledRef.class, "state");
        static final int STATE_IDLE = 0;
        static final int STATE_ACQUIRED = 1;
        static final int STATE_RELEASED = 2;
        static final int STATE_INVALIDATED = 3;

        AbstractPooledRef(T poolable, PoolMetricsRecorder metricsRecorder, Clock clock) {
            this.poolable = poolable;
            this.metricsRecorder = metricsRecorder;
            this.clock = clock;
            this.creationTimestamp = clock.millis();
            this.acquireCount = 0;
            this.releaseTimestamp = -2L;
            this.state = 0;
        }

        AbstractPooledRef(AbstractPooledRef<T> oldRef) {
            this.poolable = oldRef.poolable;
            this.metricsRecorder = oldRef.metricsRecorder;
            this.clock = oldRef.clock;
            this.creationTimestamp = oldRef.creationTimestamp;
            this.acquireCount = oldRef.acquireCount();
            this.releaseTimestamp = oldRef.releaseTimestamp;
            this.state = oldRef.state == 3 ? 3 : 0;
        }

        @Override
        public T poolable() {
            return this.poolable;
        }

        @Override
        public PooledRefMetadata metadata() {
            return this;
        }

        void markAcquired() {
            if (STATE.compareAndSet(this, 0, 1)) {
                long rt = this.releaseTimestamp;
                if (rt > 0L) {
                    this.metricsRecorder.recordIdleTime(this.clock.millis() - rt);
                } else {
                    this.metricsRecorder.recordIdleTime(this.clock.millis() - this.creationTimestamp);
                }
            }
        }

        boolean markReleased() {
            int s2;
            do {
                if ((s2 = this.state) != 2 && s2 != 3) continue;
                return false;
            } while (!STATE.compareAndSet(this, s2, 2));
            this.releaseTimestamp = this.clock.millis();
            return true;
        }

        boolean markSoftInvalidate() {
            int s2;
            do {
                if ((s2 = this.state) != 3 && s2 != 2) continue;
                return false;
            } while (!STATE.compareAndSet(this, s2, 3));
            return true;
        }

        boolean markDestroy() {
            int s2;
            do {
                if ((s2 = this.state) != 3) continue;
                return false;
            } while (!STATE.compareAndSet(this, s2, 3));
            return true;
        }

        @Override
        public int acquireCount() {
            if (STATE.get(this) == 0) {
                return this.acquireCount;
            }
            return this.acquireCount + 1;
        }

        @Override
        public long lifeTime() {
            return this.clock.millis() - this.creationTimestamp;
        }

        @Override
        public long idleTime() {
            if (STATE.get(this) == 1) {
                return 0L;
            }
            long rt = this.releaseTimestamp;
            if (rt < 0L) {
                rt = this.creationTimestamp;
            }
            return this.clock.millis() - rt;
        }

        @Override
        public long allocationTimestamp() {
            return this.creationTimestamp;
        }

        @Override
        public long releaseTimestamp() {
            if (STATE.get(this) == 1) {
                return 0L;
            }
            long rt = this.releaseTimestamp;
            if (rt < 0L) {
                rt = this.creationTimestamp;
            }
            return rt;
        }

        @Override
        public abstract Mono<Void> release();

        @Override
        public abstract Mono<Void> invalidate();

        public String toString() {
            return "PooledRef{poolable=" + this.poolable + ", lifeTime=" + this.lifeTime() + "ms, idleTime=" + this.idleTime() + "ms, acquireCount=" + this.acquireCount + '}';
        }
    }
}

