/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.netty.internal.shaded.reactor.pool;

import com.dataiku.dss.shadelibazure.org.reactivestreams.Publisher;
import com.dataiku.dss.shadelibazure.reactor.core.Disposable;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import com.dataiku.dss.shadelibazure.reactor.netty.internal.shaded.reactor.pool.PoolConfig;
import com.dataiku.dss.shadelibazure.reactor.netty.internal.shaded.reactor.pool.PooledRef;
import java.time.Duration;
import java.util.function.Function;

public interface Pool<POOLABLE>
extends Disposable {
    public Mono<Integer> warmup();

    public Mono<PooledRef<POOLABLE>> acquire();

    public Mono<PooledRef<POOLABLE>> acquire(Duration var1);

    default public <V> Flux<V> withPoolable(Function<POOLABLE, Publisher<V>> scopeFunction) {
        return Flux.usingWhen(this.acquire(), slot -> {
            Object poolable = slot.poolable();
            if (poolable == null) {
                return Mono.empty();
            }
            return (Publisher)scopeFunction.apply(poolable);
        }, PooledRef::release, (ref, error) -> ref.release(), PooledRef::release);
    }

    default public PoolConfig<POOLABLE> config() {
        throw new UnsupportedOperationException("This instance of Pool doesn't expose its configuration");
    }

    @Override
    default public void dispose() {
        this.disposeLater().subscribe();
    }

    public Mono<Void> disposeLater();
}

