/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.netty.resources;

import com.dataiku.dss.shadelibazure.io.netty.resolver.AddressResolverGroup;
import com.dataiku.dss.shadelibazure.reactor.core.Disposable;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import com.dataiku.dss.shadelibazure.reactor.netty.Connection;
import com.dataiku.dss.shadelibazure.reactor.netty.ConnectionObserver;
import com.dataiku.dss.shadelibazure.reactor.netty.resources.ConnectionPoolMetrics;
import com.dataiku.dss.shadelibazure.reactor.netty.resources.DefaultPooledConnectionProvider;
import com.dataiku.dss.shadelibazure.reactor.netty.resources.NewConnectionProvider;
import com.dataiku.dss.shadelibazure.reactor.netty.transport.TransportConfig;
import com.dataiku.dss.shadelibazure.reactor.util.Metrics;
import com.dataiku.dss.shadelibazure.reactor.util.annotation.Nullable;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Supplier;

@FunctionalInterface
public interface ConnectionProvider
extends Disposable {
    public static final int DEFAULT_POOL_MAX_CONNECTIONS = Integer.parseInt(System.getProperty("com.dataiku.dss.shadelibazure.reactor.netty.pool.maxConnections", "" + Math.max(Runtime.getRuntime().availableProcessors(), 8) * 2));
    public static final long DEFAULT_POOL_ACQUIRE_TIMEOUT = Long.parseLong(System.getProperty("com.dataiku.dss.shadelibazure.reactor.netty.pool.acquireTimeout", "45000"));
    public static final long DEFAULT_POOL_MAX_IDLE_TIME = Long.parseLong(System.getProperty("com.dataiku.dss.shadelibazure.reactor.netty.pool.maxIdleTime", "-1"));
    public static final long DEFAULT_POOL_MAX_LIFE_TIME = Long.parseLong(System.getProperty("com.dataiku.dss.shadelibazure.reactor.netty.pool.maxLifeTime", "-1"));
    public static final String LEASING_STRATEGY_FIFO = "fifo";
    public static final String LEASING_STRATEGY_LIFO = "lifo";
    public static final String DEFAULT_POOL_LEASING_STRATEGY = System.getProperty("com.dataiku.dss.shadelibazure.reactor.netty.pool.leasingStrategy", "fifo").toLowerCase(Locale.ENGLISH);

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public static ConnectionProvider newConnection() {
        return NewConnectionProvider.INSTANCE;
    }

    public static ConnectionProvider create(String name) {
        return ((Builder)((Builder)((Builder)ConnectionProvider.builder(name).maxConnections(DEFAULT_POOL_MAX_CONNECTIONS)).pendingAcquireMaxCount(500)).pendingAcquireTimeout(Duration.ofMillis(DEFAULT_POOL_ACQUIRE_TIMEOUT))).build();
    }

    public static ConnectionProvider create(String name, int maxConnections) {
        return ((Builder)((Builder)ConnectionProvider.builder(name).maxConnections(maxConnections)).pendingAcquireTimeout(Duration.ofMillis(DEFAULT_POOL_ACQUIRE_TIMEOUT))).build();
    }

    public static ConnectionProvider create(String name, int maxConnections, boolean metricsEnabled) {
        return ((Builder)((Builder)((Builder)ConnectionProvider.builder(name).maxConnections(maxConnections)).pendingAcquireTimeout(Duration.ofMillis(DEFAULT_POOL_ACQUIRE_TIMEOUT))).metrics(metricsEnabled)).build();
    }

    public Mono<? extends Connection> acquire(TransportConfig var1, ConnectionObserver var2, @Nullable Supplier<? extends SocketAddress> var3, @Nullable AddressResolverGroup<?> var4);

    default public void disposeWhen(SocketAddress remoteAddress) {
    }

    @Override
    default public void dispose() {
        this.disposeLater().subscribe();
    }

    default public Mono<Void> disposeLater() {
        return Mono.empty();
    }

    default public int maxConnections() {
        return -1;
    }

    @Nullable
    default public Map<SocketAddress, Integer> maxConnectionsPerHost() {
        return null;
    }

    @Nullable
    default public Builder mutate() {
        return null;
    }

    @Nullable
    default public String name() {
        return null;
    }

    public static interface MeterRegistrar {
        public void registerMetrics(String var1, String var2, SocketAddress var3, ConnectionPoolMetrics var4);

        default public void deRegisterMetrics(String poolName, String id, SocketAddress remoteAddress) {
        }
    }

    public static final class HostSpecificSpec
    extends ConnectionPoolSpec<HostSpecificSpec> {
    }

    public static class ConnectionPoolSpec<SPEC extends ConnectionPoolSpec<SPEC>>
    implements Supplier<SPEC> {
        static final Duration EVICT_IN_BACKGROUND_DISABLED = Duration.ZERO;
        static final int PENDING_ACQUIRE_MAX_COUNT_NOT_SPECIFIED = -2;
        Duration evictionInterval = EVICT_IN_BACKGROUND_DISABLED;
        int maxConnections = DEFAULT_POOL_MAX_CONNECTIONS;
        int pendingAcquireMaxCount = -2;
        Duration pendingAcquireTimeout = Duration.ofMillis(DEFAULT_POOL_ACQUIRE_TIMEOUT);
        Duration maxIdleTime;
        Duration maxLifeTime;
        boolean metricsEnabled;
        String leasingStrategy = DEFAULT_POOL_LEASING_STRATEGY;
        Supplier<? extends MeterRegistrar> registrar;
        BiFunction<Runnable, Duration, Disposable> pendingAcquireTimer;
        AllocationStrategy<?> allocationStrategy;
        BiPredicate<Connection, ConnectionMetadata> evictionPredicate;

        private ConnectionPoolSpec() {
            if (DEFAULT_POOL_MAX_IDLE_TIME > -1L) {
                this.maxIdleTime(Duration.ofMillis(DEFAULT_POOL_MAX_IDLE_TIME));
            }
            if (DEFAULT_POOL_MAX_LIFE_TIME > -1L) {
                this.maxLifeTime(Duration.ofMillis(DEFAULT_POOL_MAX_LIFE_TIME));
            }
        }

        ConnectionPoolSpec(ConnectionPoolSpec<SPEC> copy) {
            this.evictionInterval = copy.evictionInterval;
            this.maxConnections = copy.maxConnections;
            this.pendingAcquireMaxCount = copy.pendingAcquireMaxCount;
            this.pendingAcquireTimeout = copy.pendingAcquireTimeout;
            this.maxIdleTime = copy.maxIdleTime;
            this.maxLifeTime = copy.maxLifeTime;
            this.metricsEnabled = copy.metricsEnabled;
            this.leasingStrategy = copy.leasingStrategy;
            this.registrar = copy.registrar;
            this.pendingAcquireTimer = copy.pendingAcquireTimer;
            this.allocationStrategy = copy.allocationStrategy;
            this.evictionPredicate = copy.evictionPredicate;
        }

        public final SPEC pendingAcquireTimeout(Duration pendingAcquireTimeout) {
            this.pendingAcquireTimeout = Objects.requireNonNull(pendingAcquireTimeout, "pendingAcquireTimeout");
            return (SPEC)this.get();
        }

        public final SPEC maxConnections(int maxConnections) {
            if (maxConnections <= 0) {
                throw new IllegalArgumentException("Max Connections value must be strictly positive");
            }
            this.maxConnections = maxConnections;
            this.allocationStrategy = null;
            return (SPEC)this.get();
        }

        public final SPEC pendingAcquireMaxCount(int pendingAcquireMaxCount) {
            if (pendingAcquireMaxCount != -1 && pendingAcquireMaxCount <= 0) {
                throw new IllegalArgumentException("Pending acquire max count must be strictly positive");
            }
            this.pendingAcquireMaxCount = pendingAcquireMaxCount;
            return (SPEC)this.get();
        }

        public final SPEC maxIdleTime(Duration maxIdleTime) {
            this.maxIdleTime = Objects.requireNonNull(maxIdleTime);
            return (SPEC)this.get();
        }

        public final SPEC maxLifeTime(Duration maxLifeTime) {
            this.maxLifeTime = Objects.requireNonNull(maxLifeTime);
            return (SPEC)this.get();
        }

        public final SPEC evictionPredicate(BiPredicate<Connection, ConnectionMetadata> evictionPredicate) {
            this.evictionPredicate = Objects.requireNonNull(evictionPredicate);
            return (SPEC)this.get();
        }

        public final SPEC metrics(boolean metricsEnabled) {
            if (metricsEnabled && !Metrics.isInstrumentationAvailable()) {
                throw new UnsupportedOperationException("To enable metrics, you must add the dependency `io.micrometer:micrometer-core` to the class path first");
            }
            this.metricsEnabled = metricsEnabled;
            return (SPEC)this.get();
        }

        public final SPEC metrics(boolean metricsEnabled, Supplier<? extends MeterRegistrar> registrar) {
            this.metricsEnabled = metricsEnabled;
            this.registrar = Objects.requireNonNull(registrar);
            return (SPEC)this.get();
        }

        public final SPEC lifo() {
            this.leasingStrategy = ConnectionProvider.LEASING_STRATEGY_LIFO;
            return (SPEC)this.get();
        }

        public final SPEC fifo() {
            this.leasingStrategy = ConnectionProvider.LEASING_STRATEGY_FIFO;
            return (SPEC)this.get();
        }

        public final SPEC evictInBackground(Duration evictionInterval) {
            this.evictionInterval = Objects.requireNonNull(evictionInterval, "evictionInterval");
            return (SPEC)this.get();
        }

        public final SPEC pendingAcquireTimer(BiFunction<Runnable, Duration, Disposable> pendingAcquireTimer) {
            this.pendingAcquireTimer = Objects.requireNonNull(pendingAcquireTimer, "pendingAcquireTimer");
            return (SPEC)this.get();
        }

        public final SPEC allocationStrategy(AllocationStrategy<?> allocationStrategy) {
            this.allocationStrategy = Objects.requireNonNull(allocationStrategy, "allocationStrategy");
            return (SPEC)this.get();
        }

        @Override
        public SPEC get() {
            return (SPEC)this;
        }
    }

    public static final class Builder
    extends ConnectionPoolSpec<Builder> {
        static final Duration DISPOSE_INACTIVE_POOLS_IN_BACKGROUND_DISABLED = Duration.ZERO;
        String name;
        Duration inactivePoolDisposeInterval = DISPOSE_INACTIVE_POOLS_IN_BACKGROUND_DISABLED;
        Duration poolInactivity;
        Duration disposeTimeout;
        final Map<SocketAddress, ConnectionPoolSpec<?>> confPerRemoteHost = new HashMap();

        private Builder(String name) {
            this.name(name);
        }

        Builder(Builder copy) {
            super(copy);
            this.name = copy.name;
            this.inactivePoolDisposeInterval = copy.inactivePoolDisposeInterval;
            this.poolInactivity = copy.poolInactivity;
            this.disposeTimeout = copy.disposeTimeout;
            copy.confPerRemoteHost.forEach((address, spec) -> this.confPerRemoteHost.put((SocketAddress)address, new ConnectionPoolSpec(spec)));
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            return this;
        }

        public final Builder disposeInactivePoolsInBackground(Duration disposeInterval, Duration poolInactivity) {
            this.inactivePoolDisposeInterval = Objects.requireNonNull(disposeInterval, "disposeInterval");
            this.poolInactivity = Objects.requireNonNull(poolInactivity, "poolInactivity");
            return (Builder)this.get();
        }

        public final Builder disposeTimeout(Duration timeout2) {
            this.disposeTimeout = Objects.requireNonNull(timeout2, "disposeTimeout");
            return (Builder)this.get();
        }

        public final Builder forRemoteHost(SocketAddress remoteHost, Consumer<HostSpecificSpec> spec) {
            Objects.requireNonNull(remoteHost, "remoteHost");
            Objects.requireNonNull(spec, "spec");
            HostSpecificSpec builder = new HostSpecificSpec();
            spec.accept(builder);
            this.confPerRemoteHost.put(remoteHost, builder);
            return this;
        }

        public ConnectionProvider build() {
            return new DefaultPooledConnectionProvider(this);
        }
    }

    public static interface AllocationStrategy<A extends AllocationStrategy<A>> {
        public A copy();

        public int estimatePermitCount();

        public int getPermits(int var1);

        public int permitGranted();

        public int permitMinimum();

        public int permitMaximum();

        public void returnPermits(int var1);
    }

    public static interface ConnectionMetadata {
        public int acquireCount();

        public long idleTime();

        public long lifeTime();

        public long releaseTimestamp();

        public long allocationTimestamp();
    }
}

