/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.netty.resources;

import com.dataiku.dss.shadelibazure.io.netty.channel.Channel;
import com.dataiku.dss.shadelibazure.io.netty.channel.EventLoopGroup;
import com.dataiku.dss.shadelibazure.io.netty.channel.kqueue.KQueue;
import com.dataiku.dss.shadelibazure.io.netty.channel.kqueue.KQueueDatagramChannel;
import com.dataiku.dss.shadelibazure.io.netty.channel.kqueue.KQueueDomainDatagramChannel;
import com.dataiku.dss.shadelibazure.io.netty.channel.kqueue.KQueueDomainSocketChannel;
import com.dataiku.dss.shadelibazure.io.netty.channel.kqueue.KQueueEventLoopGroup;
import com.dataiku.dss.shadelibazure.io.netty.channel.kqueue.KQueueServerDomainSocketChannel;
import com.dataiku.dss.shadelibazure.io.netty.channel.kqueue.KQueueServerSocketChannel;
import com.dataiku.dss.shadelibazure.io.netty.channel.kqueue.KQueueSocketChannel;
import com.dataiku.dss.shadelibazure.io.netty.channel.socket.DatagramChannel;
import com.dataiku.dss.shadelibazure.io.netty.channel.socket.ServerSocketChannel;
import com.dataiku.dss.shadelibazure.io.netty.channel.socket.SocketChannel;
import com.dataiku.dss.shadelibazure.io.netty.channel.unix.DomainDatagramChannel;
import com.dataiku.dss.shadelibazure.io.netty.channel.unix.DomainSocketChannel;
import com.dataiku.dss.shadelibazure.io.netty.channel.unix.ServerDomainSocketChannel;
import com.dataiku.dss.shadelibazure.reactor.netty.resources.ColocatedEventLoopGroup;
import com.dataiku.dss.shadelibazure.reactor.netty.resources.DefaultLoop;
import com.dataiku.dss.shadelibazure.reactor.util.Logger;
import com.dataiku.dss.shadelibazure.reactor.util.Loggers;
import java.util.concurrent.ThreadFactory;

final class DefaultLoopKQueue
implements DefaultLoop {
    static final Logger log = Loggers.getLogger(DefaultLoopKQueue.class);
    static final boolean isKqueueAvailable;

    DefaultLoopKQueue() {
    }

    @Override
    public <CHANNEL extends Channel> CHANNEL getChannel(Class<CHANNEL> channelClass) {
        if (channelClass.equals(SocketChannel.class)) {
            return (CHANNEL)new KQueueSocketChannel();
        }
        if (channelClass.equals(ServerSocketChannel.class)) {
            return (CHANNEL)new KQueueServerSocketChannel();
        }
        if (channelClass.equals(DatagramChannel.class)) {
            return (CHANNEL)new KQueueDatagramChannel();
        }
        if (channelClass.equals(DomainSocketChannel.class)) {
            return (CHANNEL)new KQueueDomainSocketChannel();
        }
        if (channelClass.equals(ServerDomainSocketChannel.class)) {
            return (CHANNEL)new KQueueServerDomainSocketChannel();
        }
        if (channelClass.equals(DomainDatagramChannel.class)) {
            return (CHANNEL)new KQueueDomainDatagramChannel();
        }
        throw new IllegalArgumentException("Unsupported channel type: " + channelClass.getSimpleName());
    }

    @Override
    public <CHANNEL extends Channel> Class<? extends CHANNEL> getChannelClass(Class<CHANNEL> channelClass) {
        if (channelClass.equals(SocketChannel.class)) {
            return KQueueSocketChannel.class;
        }
        if (channelClass.equals(ServerSocketChannel.class)) {
            return KQueueServerSocketChannel.class;
        }
        if (channelClass.equals(DatagramChannel.class)) {
            return KQueueDatagramChannel.class;
        }
        throw new IllegalArgumentException("Unsupported channel type: " + channelClass.getSimpleName());
    }

    @Override
    public String getName() {
        return "kqueue";
    }

    @Override
    public EventLoopGroup newEventLoopGroup(int threads, ThreadFactory factory2) {
        return new KQueueEventLoopGroup(threads, factory2);
    }

    @Override
    public boolean supportGroup(EventLoopGroup group) {
        if (group instanceof ColocatedEventLoopGroup) {
            group = ((ColocatedEventLoopGroup)group).get();
        }
        return group instanceof KQueueEventLoopGroup;
    }

    static {
        boolean kqueueCheck = false;
        try {
            Class.forName("com.dataiku.dss.shadelibazure.io.netty.channel.kqueue.KQueue");
            kqueueCheck = KQueue.isAvailable();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        isKqueueAvailable = kqueueCheck;
        if (log.isDebugEnabled()) {
            log.debug("Default KQueue support : " + isKqueueAvailable);
        }
    }
}

