/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.netty.transport;

import com.dataiku.dss.shadelibazure.io.netty.channel.Channel;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelOption;
import com.dataiku.dss.shadelibazure.io.netty.channel.EventLoopGroup;
import com.dataiku.dss.shadelibazure.io.netty.channel.group.ChannelGroup;
import com.dataiku.dss.shadelibazure.io.netty.channel.socket.ServerSocketChannel;
import com.dataiku.dss.shadelibazure.io.netty.channel.unix.ServerDomainSocketChannel;
import com.dataiku.dss.shadelibazure.io.netty.util.AttributeKey;
import com.dataiku.dss.shadelibazure.io.netty.util.concurrent.Future;
import com.dataiku.dss.shadelibazure.io.netty.util.concurrent.GenericFutureListener;
import com.dataiku.dss.shadelibazure.reactor.netty.ChannelPipelineConfigurer;
import com.dataiku.dss.shadelibazure.reactor.netty.Connection;
import com.dataiku.dss.shadelibazure.reactor.netty.ConnectionObserver;
import com.dataiku.dss.shadelibazure.reactor.netty.DisposableServer;
import com.dataiku.dss.shadelibazure.reactor.netty.ReactorNetty;
import com.dataiku.dss.shadelibazure.reactor.netty.transport.TransportConfig;
import com.dataiku.dss.shadelibazure.reactor.util.annotation.Nullable;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;

public abstract class ServerTransportConfig<CONF extends TransportConfig>
extends TransportConfig {
    Map<AttributeKey<?>, ?> childAttrs;
    ConnectionObserver childObserver;
    Map<ChannelOption<?>, ?> childOptions;
    Consumer<? super CONF> doOnBind;
    Consumer<? super DisposableServer> doOnBound;
    Consumer<? super Connection> doOnConnection;
    Consumer<? super DisposableServer> doOnUnbound;

    public final Map<AttributeKey<?>, ?> childAttributes() {
        if (this.childAttrs == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.childAttrs);
    }

    public final ConnectionObserver childObserver() {
        return this.childObserver;
    }

    public final Map<ChannelOption<?>, ?> childOptions() {
        if (this.childOptions == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.childOptions);
    }

    @Nullable
    public final Consumer<? super CONF> doOnBind() {
        return this.doOnBind;
    }

    @Nullable
    public final Consumer<? super DisposableServer> doOnBound() {
        return this.doOnBound;
    }

    @Nullable
    public final Consumer<? super Connection> doOnConnection() {
        return this.doOnConnection;
    }

    @Nullable
    public final Consumer<? super DisposableServer> doOnUnbound() {
        return this.doOnUnbound;
    }

    protected ServerTransportConfig(Map<ChannelOption<?>, ?> options, Map<ChannelOption<?>, ?> childOptions, Supplier<? extends SocketAddress> bindAddress) {
        super(options, bindAddress);
        this.childAttrs = Collections.emptyMap();
        this.childObserver = ConnectionObserver.emptyListener();
        this.childOptions = Objects.requireNonNull(childOptions, "childOptions");
    }

    protected ServerTransportConfig(ServerTransportConfig<CONF> parent) {
        super(parent);
        this.childAttrs = parent.childAttrs;
        this.childObserver = parent.childObserver;
        this.childOptions = parent.childOptions;
        this.doOnBind = parent.doOnBind;
        this.doOnBound = parent.doOnBound;
        this.doOnConnection = parent.doOnConnection;
        this.doOnUnbound = parent.doOnUnbound;
    }

    @Override
    protected Class<? extends Channel> channelType(boolean isDomainSocket) {
        return isDomainSocket ? ServerDomainSocketChannel.class : ServerSocketChannel.class;
    }

    protected ConnectionObserver defaultChildObserver() {
        if (this.channelGroup() == null && this.doOnConnection() == null) {
            return ConnectionObserver.emptyListener();
        }
        return new ServerTransportDoOnConnection(this.channelGroup(), this.doOnConnection());
    }

    @Override
    protected ConnectionObserver defaultConnectionObserver() {
        if (this.doOnBound() == null && this.doOnUnbound() == null) {
            return ConnectionObserver.emptyListener();
        }
        return new ServerTransportDoOn(this.doOnBound(), this.doOnUnbound());
    }

    @Override
    protected ChannelPipelineConfigurer defaultOnChannelInit() {
        return ChannelPipelineConfigurer.emptyConfigurer();
    }

    @Override
    protected final EventLoopGroup eventLoopGroup() {
        return this.loopResources().onServerSelect(this.isPreferNative());
    }

    final EventLoopGroup childEventLoopGroup() {
        return this.loopResources().onServer(this.isPreferNative());
    }

    static final class ServerTransportDoOnConnection
    implements ConnectionObserver {
        final ChannelGroup channelGroup;
        final Consumer<? super Connection> doOnConnection;

        ServerTransportDoOnConnection(@Nullable ChannelGroup channelGroup, @Nullable Consumer<? super Connection> doOnConnection) {
            this.channelGroup = channelGroup;
            this.doOnConnection = doOnConnection;
        }

        @Override
        public void onStateChange(Connection connection, ConnectionObserver.State newState) {
            if (this.channelGroup != null && newState == ConnectionObserver.State.CONNECTED) {
                this.channelGroup.add(connection.channel());
                return;
            }
            if (this.doOnConnection != null && newState == ConnectionObserver.State.CONFIGURED) {
                try {
                    this.doOnConnection.accept(connection);
                }
                catch (Throwable t) {
                    TransportConfig.log.error(ReactorNetty.format(connection.channel(), ""), t);
                    connection.channel().close();
                }
            }
        }
    }

    static final class ServerTransportDoOn
    implements ConnectionObserver {
        final Consumer<? super DisposableServer> doOnBound;
        final Consumer<? super DisposableServer> doOnUnbound;

        ServerTransportDoOn(@Nullable Consumer<? super DisposableServer> doOnBound, @Nullable Consumer<? super DisposableServer> doOnUnbound) {
            this.doOnBound = doOnBound;
            this.doOnUnbound = doOnUnbound;
        }

        @Override
        public void onStateChange(Connection connection, ConnectionObserver.State newState) {
            if (newState == ConnectionObserver.State.CONNECTED) {
                if (this.doOnBound != null) {
                    this.doOnBound.accept((DisposableServer)((Object)connection));
                }
                if (this.doOnUnbound != null) {
                    connection.channel().closeFuture().addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)f -> this.doOnUnbound.accept((DisposableServer)((Object)connection))));
                }
            }
        }
    }
}

