/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.netty.udp;

import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelOption;
import com.dataiku.dss.shadelibazure.io.netty.channel.EventLoopGroup;
import com.dataiku.dss.shadelibazure.io.netty.channel.socket.InternetProtocolFamily;
import com.dataiku.dss.shadelibazure.io.netty.handler.logging.LogLevel;
import com.dataiku.dss.shadelibazure.io.netty.util.AttributeKey;
import com.dataiku.dss.shadelibazure.org.reactivestreams.Publisher;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import com.dataiku.dss.shadelibazure.reactor.netty.Connection;
import com.dataiku.dss.shadelibazure.reactor.netty.ConnectionObserver;
import com.dataiku.dss.shadelibazure.reactor.netty.ReactorNetty;
import com.dataiku.dss.shadelibazure.reactor.netty.channel.ChannelMetricsRecorder;
import com.dataiku.dss.shadelibazure.reactor.netty.resources.LoopResources;
import com.dataiku.dss.shadelibazure.reactor.netty.transport.ClientTransport;
import com.dataiku.dss.shadelibazure.reactor.netty.udp.UdpClientConfig;
import com.dataiku.dss.shadelibazure.reactor.netty.udp.UdpClientConnect;
import com.dataiku.dss.shadelibazure.reactor.netty.udp.UdpInbound;
import com.dataiku.dss.shadelibazure.reactor.netty.udp.UdpOutbound;
import com.dataiku.dss.shadelibazure.reactor.util.Logger;
import com.dataiku.dss.shadelibazure.reactor.util.Loggers;
import com.dataiku.dss.shadelibazure.reactor.util.annotation.Nullable;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;

public abstract class UdpClient
extends ClientTransport<UdpClient, UdpClientConfig> {
    static final Logger log = Loggers.getLogger(UdpClient.class);

    public static UdpClient create() {
        return UdpClientConnect.INSTANCE;
    }

    @Override
    public final <A> UdpClient attr(AttributeKey<A> key, @Nullable A value) {
        return (UdpClient)super.attr(key, value);
    }

    @Override
    public final UdpClient bindAddress(Supplier<? extends SocketAddress> bindAddressSupplier) {
        return (UdpClient)super.bindAddress(bindAddressSupplier);
    }

    @Override
    public final Mono<? extends Connection> connect() {
        return super.connect();
    }

    @Override
    public final Connection connectNow() {
        return super.connectNow();
    }

    @Override
    public final Connection connectNow(Duration timeout2) {
        return super.connectNow(timeout2);
    }

    @Override
    public final UdpClient doOnConnect(Consumer<? super UdpClientConfig> doOnConnect) {
        return (UdpClient)super.doOnConnect(doOnConnect);
    }

    @Override
    public final UdpClient doOnConnected(Consumer<? super Connection> doOnConnected) {
        return (UdpClient)super.doOnConnected(doOnConnected);
    }

    @Override
    public final UdpClient doOnDisconnected(Consumer<? super Connection> doOnDisconnected) {
        return (UdpClient)super.doOnDisconnected(doOnDisconnected);
    }

    public final UdpClient handle(BiFunction<? super UdpInbound, ? super UdpOutbound, ? extends Publisher<Void>> handler) {
        Objects.requireNonNull(handler, "handler");
        return this.doOnConnected((Consumer)new OnConnectedHandle(handler));
    }

    @Override
    public final UdpClient host(String host) {
        return (UdpClient)super.host(host);
    }

    @Override
    public final UdpClient metrics(boolean enable) {
        return (UdpClient)super.metrics(enable);
    }

    @Override
    public final UdpClient metrics(boolean enable, Supplier<? extends ChannelMetricsRecorder> recorder) {
        return (UdpClient)super.metrics(enable, recorder);
    }

    @Override
    public final UdpClient observe(ConnectionObserver observer) {
        return (UdpClient)super.observe(observer);
    }

    @Override
    public final <O> UdpClient option(ChannelOption<O> key, @Nullable O value) {
        return (UdpClient)super.option(key, value);
    }

    @Override
    public final UdpClient port(int port) {
        return (UdpClient)super.port(port);
    }

    @Override
    public final UdpClient remoteAddress(Supplier<? extends SocketAddress> remoteAddressSupplier) {
        return (UdpClient)super.remoteAddress(remoteAddressSupplier);
    }

    @Override
    public final UdpClient runOn(EventLoopGroup eventLoopGroup) {
        return (UdpClient)super.runOn(eventLoopGroup);
    }

    @Override
    public final UdpClient runOn(LoopResources channelResources) {
        return (UdpClient)super.runOn(channelResources);
    }

    @Override
    public final UdpClient runOn(LoopResources loopResources, boolean preferNative) {
        Objects.requireNonNull(loopResources, "loopResources");
        UdpClient dup = (UdpClient)super.runOn(loopResources, preferNative);
        ((UdpClientConfig)dup.configuration()).family = null;
        return dup;
    }

    public final UdpClient runOn(LoopResources loopResources, InternetProtocolFamily family) {
        Objects.requireNonNull(loopResources, "loopResources");
        Objects.requireNonNull(family, "family");
        UdpClient dup = (UdpClient)super.runOn(loopResources, false);
        ((UdpClientConfig)dup.configuration()).family = family;
        return dup;
    }

    @Override
    public final UdpClient wiretap(boolean enable) {
        return (UdpClient)super.wiretap(enable);
    }

    @Override
    public final UdpClient wiretap(String category) {
        return (UdpClient)super.wiretap(category);
    }

    @Override
    public final UdpClient wiretap(String category, LogLevel level) {
        return (UdpClient)super.wiretap(category, level);
    }

    static final class OnConnectedHandle
    implements Consumer<Connection> {
        final BiFunction<? super UdpInbound, ? super UdpOutbound, ? extends Publisher<Void>> handler;

        OnConnectedHandle(BiFunction<? super UdpInbound, ? super UdpOutbound, ? extends Publisher<Void>> handler) {
            this.handler = handler;
        }

        @Override
        public void accept(Connection c) {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(c.channel(), "Handler is being applied: {}"), this.handler);
            }
            Mono.fromDirect(this.handler.apply((UdpInbound)((Object)c), (UdpOutbound)((Object)c))).subscribe(c.disposeSubscriber());
        }
    }
}

