/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.netty.udp;

import com.dataiku.dss.shadelibazure.io.netty.channel.Channel;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelFactory;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelOption;
import com.dataiku.dss.shadelibazure.io.netty.channel.EventLoopGroup;
import com.dataiku.dss.shadelibazure.io.netty.channel.socket.DatagramChannel;
import com.dataiku.dss.shadelibazure.io.netty.channel.socket.InternetProtocolFamily;
import com.dataiku.dss.shadelibazure.io.netty.channel.socket.nio.NioDatagramChannel;
import com.dataiku.dss.shadelibazure.io.netty.channel.unix.DomainDatagramChannel;
import com.dataiku.dss.shadelibazure.io.netty.handler.logging.LogLevel;
import com.dataiku.dss.shadelibazure.io.netty.handler.logging.LoggingHandler;
import com.dataiku.dss.shadelibazure.io.netty.resolver.AddressResolverGroup;
import com.dataiku.dss.shadelibazure.reactor.netty.channel.ChannelMetricsRecorder;
import com.dataiku.dss.shadelibazure.reactor.netty.channel.ChannelOperations;
import com.dataiku.dss.shadelibazure.reactor.netty.channel.MicrometerChannelMetricsRecorder;
import com.dataiku.dss.shadelibazure.reactor.netty.resources.ConnectionProvider;
import com.dataiku.dss.shadelibazure.reactor.netty.resources.LoopResources;
import com.dataiku.dss.shadelibazure.reactor.netty.transport.ClientTransportConfig;
import com.dataiku.dss.shadelibazure.reactor.netty.transport.logging.AdvancedByteBufFormat;
import com.dataiku.dss.shadelibazure.reactor.netty.udp.UdpClient;
import com.dataiku.dss.shadelibazure.reactor.netty.udp.UdpOperations;
import com.dataiku.dss.shadelibazure.reactor.netty.udp.UdpResources;
import com.dataiku.dss.shadelibazure.reactor.util.annotation.Nullable;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.function.Supplier;

public final class UdpClientConfig
extends ClientTransportConfig<UdpClientConfig> {
    InternetProtocolFamily family;
    static final ChannelOperations.OnSetup DEFAULT_OPS = (ch, c, msg) -> new UdpOperations(ch, c);
    static final LoggingHandler LOGGING_HANDLER = AdvancedByteBufFormat.HEX_DUMP.toLoggingHandler(UdpClient.class.getName(), LogLevel.DEBUG, Charset.defaultCharset());

    @Override
    public final ChannelOperations.OnSetup channelOperationsProvider() {
        return DEFAULT_OPS;
    }

    @Nullable
    public final InternetProtocolFamily family() {
        return this.family;
    }

    UdpClientConfig(ConnectionProvider connectionProvider, Map<ChannelOption<?>, ?> options, Supplier<? extends SocketAddress> remoteAddress) {
        super(connectionProvider, options, remoteAddress);
    }

    UdpClientConfig(UdpClientConfig parent) {
        super(parent);
        this.family = parent.family;
    }

    @Override
    protected Class<? extends Channel> channelType(boolean isDomainSocket) {
        return isDomainSocket ? DomainDatagramChannel.class : DatagramChannel.class;
    }

    @Override
    protected ChannelFactory<? extends Channel> connectionFactory(EventLoopGroup elg, boolean isDomainSocket) {
        if (this.isPreferNative()) {
            return super.connectionFactory(elg, isDomainSocket);
        }
        return () -> new NioDatagramChannel(this.family());
    }

    @Override
    protected AddressResolverGroup<?> defaultAddressResolverGroup() {
        return UdpResources.get().getOrCreateDefaultResolver();
    }

    @Override
    protected LoggingHandler defaultLoggingHandler() {
        return LOGGING_HANDLER;
    }

    @Override
    protected LoopResources defaultLoopResources() {
        return UdpResources.get();
    }

    @Override
    protected ChannelMetricsRecorder defaultMetricsRecorder() {
        return MicrometerUdpClientMetricsRecorder.INSTANCE;
    }

    static final class MicrometerUdpClientMetricsRecorder
    extends MicrometerChannelMetricsRecorder {
        static final MicrometerUdpClientMetricsRecorder INSTANCE = new MicrometerUdpClientMetricsRecorder();

        MicrometerUdpClientMetricsRecorder() {
            super("com.dataiku.dss.shadelibazure.reactor.netty.udp.client", "udp");
        }
    }
}

