/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model;

import com.dataiku.dss.legacy.aws.com.amazonaws.AmazonWebServiceRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.internal.SdkInternalList;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.PlacementStrategy;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.SpreadLevel;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.TagSpecification;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.transform.CreatePlacementGroupRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class CreatePlacementGroupRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<CreatePlacementGroupRequest> {
    private String groupName;
    private String strategy;
    private Integer partitionCount;
    private SdkInternalList<TagSpecification> tagSpecifications;
    private String spreadLevel;

    public CreatePlacementGroupRequest() {
    }

    public CreatePlacementGroupRequest(String groupName, String strategy) {
        this.setGroupName(groupName);
        this.setStrategy(strategy);
    }

    public CreatePlacementGroupRequest(String groupName, PlacementStrategy strategy) {
        this.setGroupName(groupName);
        this.setStrategy(strategy.toString());
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public CreatePlacementGroupRequest withGroupName(String groupName) {
        this.setGroupName(groupName);
        return this;
    }

    public void setStrategy(String strategy) {
        this.strategy = strategy;
    }

    public String getStrategy() {
        return this.strategy;
    }

    public CreatePlacementGroupRequest withStrategy(String strategy) {
        this.setStrategy(strategy);
        return this;
    }

    public void setStrategy(PlacementStrategy strategy) {
        this.withStrategy(strategy);
    }

    public CreatePlacementGroupRequest withStrategy(PlacementStrategy strategy) {
        this.strategy = strategy.toString();
        return this;
    }

    public void setPartitionCount(Integer partitionCount) {
        this.partitionCount = partitionCount;
    }

    public Integer getPartitionCount() {
        return this.partitionCount;
    }

    public CreatePlacementGroupRequest withPartitionCount(Integer partitionCount) {
        this.setPartitionCount(partitionCount);
        return this;
    }

    public List<TagSpecification> getTagSpecifications() {
        if (this.tagSpecifications == null) {
            this.tagSpecifications = new SdkInternalList();
        }
        return this.tagSpecifications;
    }

    public void setTagSpecifications(Collection<TagSpecification> tagSpecifications) {
        if (tagSpecifications == null) {
            this.tagSpecifications = null;
            return;
        }
        this.tagSpecifications = new SdkInternalList<TagSpecification>(tagSpecifications);
    }

    public CreatePlacementGroupRequest withTagSpecifications(TagSpecification ... tagSpecifications) {
        if (this.tagSpecifications == null) {
            this.setTagSpecifications(new SdkInternalList<TagSpecification>(tagSpecifications.length));
        }
        for (TagSpecification ele : tagSpecifications) {
            this.tagSpecifications.add(ele);
        }
        return this;
    }

    public CreatePlacementGroupRequest withTagSpecifications(Collection<TagSpecification> tagSpecifications) {
        this.setTagSpecifications(tagSpecifications);
        return this;
    }

    public void setSpreadLevel(String spreadLevel) {
        this.spreadLevel = spreadLevel;
    }

    public String getSpreadLevel() {
        return this.spreadLevel;
    }

    public CreatePlacementGroupRequest withSpreadLevel(String spreadLevel) {
        this.setSpreadLevel(spreadLevel);
        return this;
    }

    public void setSpreadLevel(SpreadLevel spreadLevel) {
        this.withSpreadLevel(spreadLevel);
    }

    public CreatePlacementGroupRequest withSpreadLevel(SpreadLevel spreadLevel) {
        this.spreadLevel = spreadLevel.toString();
        return this;
    }

    @Override
    public Request<CreatePlacementGroupRequest> getDryRunRequest() {
        Request<CreatePlacementGroupRequest> request = new CreatePlacementGroupRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getGroupName() != null) {
            sb.append("GroupName: ").append(this.getGroupName()).append(",");
        }
        if (this.getStrategy() != null) {
            sb.append("Strategy: ").append(this.getStrategy()).append(",");
        }
        if (this.getPartitionCount() != null) {
            sb.append("PartitionCount: ").append(this.getPartitionCount()).append(",");
        }
        if (this.getTagSpecifications() != null) {
            sb.append("TagSpecifications: ").append(this.getTagSpecifications()).append(",");
        }
        if (this.getSpreadLevel() != null) {
            sb.append("SpreadLevel: ").append(this.getSpreadLevel());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePlacementGroupRequest)) {
            return false;
        }
        CreatePlacementGroupRequest other = (CreatePlacementGroupRequest)obj;
        if (other.getGroupName() == null ^ this.getGroupName() == null) {
            return false;
        }
        if (other.getGroupName() != null && !other.getGroupName().equals(this.getGroupName())) {
            return false;
        }
        if (other.getStrategy() == null ^ this.getStrategy() == null) {
            return false;
        }
        if (other.getStrategy() != null && !other.getStrategy().equals(this.getStrategy())) {
            return false;
        }
        if (other.getPartitionCount() == null ^ this.getPartitionCount() == null) {
            return false;
        }
        if (other.getPartitionCount() != null && !other.getPartitionCount().equals(this.getPartitionCount())) {
            return false;
        }
        if (other.getTagSpecifications() == null ^ this.getTagSpecifications() == null) {
            return false;
        }
        if (other.getTagSpecifications() != null && !other.getTagSpecifications().equals(this.getTagSpecifications())) {
            return false;
        }
        if (other.getSpreadLevel() == null ^ this.getSpreadLevel() == null) {
            return false;
        }
        return other.getSpreadLevel() == null || other.getSpreadLevel().equals(this.getSpreadLevel());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getGroupName() == null ? 0 : this.getGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getStrategy() == null ? 0 : this.getStrategy().hashCode());
        hashCode = 31 * hashCode + (this.getPartitionCount() == null ? 0 : this.getPartitionCount().hashCode());
        hashCode = 31 * hashCode + (this.getTagSpecifications() == null ? 0 : this.getTagSpecifications().hashCode());
        hashCode = 31 * hashCode + (this.getSpreadLevel() == null ? 0 : this.getSpreadLevel().hashCode());
        return hashCode;
    }

    @Override
    public CreatePlacementGroupRequest clone() {
        return (CreatePlacementGroupRequest)super.clone();
    }
}

