/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.internal.SdkInternalList;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.CreateFlowLogsRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.DestinationOptionsRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.Tag;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.TagSpecification;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;

public class CreateFlowLogsRequestMarshaller
implements Marshaller<Request<CreateFlowLogsRequest>, CreateFlowLogsRequest> {
    @Override
    public Request<CreateFlowLogsRequest> marshall(CreateFlowLogsRequest createFlowLogsRequest) {
        DestinationOptionsRequest destinationOptions;
        SdkInternalList createFlowLogsRequestTagSpecificationsList;
        SdkInternalList createFlowLogsRequestResourceIdsList;
        if (createFlowLogsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateFlowLogsRequest> request = new DefaultRequest<CreateFlowLogsRequest>(createFlowLogsRequest, "AmazonEC2");
        request.addParameter("Action", "CreateFlowLogs");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createFlowLogsRequest.getClientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString(createFlowLogsRequest.getClientToken()));
        }
        if (createFlowLogsRequest.getDeliverLogsPermissionArn() != null) {
            request.addParameter("DeliverLogsPermissionArn", StringUtils.fromString(createFlowLogsRequest.getDeliverLogsPermissionArn()));
        }
        if (createFlowLogsRequest.getDeliverCrossAccountRole() != null) {
            request.addParameter("DeliverCrossAccountRole", StringUtils.fromString(createFlowLogsRequest.getDeliverCrossAccountRole()));
        }
        if (createFlowLogsRequest.getLogGroupName() != null) {
            request.addParameter("LogGroupName", StringUtils.fromString(createFlowLogsRequest.getLogGroupName()));
        }
        if (!(createFlowLogsRequestResourceIdsList = (SdkInternalList)createFlowLogsRequest.getResourceIds()).isEmpty() || !createFlowLogsRequestResourceIdsList.isAutoConstruct()) {
            int resourceIdsListIndex = 1;
            for (String createFlowLogsRequestResourceIdsListValue : createFlowLogsRequestResourceIdsList) {
                if (createFlowLogsRequestResourceIdsListValue != null) {
                    request.addParameter("ResourceId." + resourceIdsListIndex, StringUtils.fromString(createFlowLogsRequestResourceIdsListValue));
                }
                ++resourceIdsListIndex;
            }
        }
        if (createFlowLogsRequest.getResourceType() != null) {
            request.addParameter("ResourceType", StringUtils.fromString(createFlowLogsRequest.getResourceType()));
        }
        if (createFlowLogsRequest.getTrafficType() != null) {
            request.addParameter("TrafficType", StringUtils.fromString(createFlowLogsRequest.getTrafficType()));
        }
        if (createFlowLogsRequest.getLogDestinationType() != null) {
            request.addParameter("LogDestinationType", StringUtils.fromString(createFlowLogsRequest.getLogDestinationType()));
        }
        if (createFlowLogsRequest.getLogDestination() != null) {
            request.addParameter("LogDestination", StringUtils.fromString(createFlowLogsRequest.getLogDestination()));
        }
        if (createFlowLogsRequest.getLogFormat() != null) {
            request.addParameter("LogFormat", StringUtils.fromString(createFlowLogsRequest.getLogFormat()));
        }
        if (!(createFlowLogsRequestTagSpecificationsList = (SdkInternalList)createFlowLogsRequest.getTagSpecifications()).isEmpty() || !createFlowLogsRequestTagSpecificationsList.isAutoConstruct()) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification createFlowLogsRequestTagSpecificationsListValue : createFlowLogsRequestTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (createFlowLogsRequestTagSpecificationsListValue.getResourceType() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString(createFlowLogsRequestTagSpecificationsListValue.getResourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)createFlowLogsRequestTagSpecificationsListValue.getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.getKey() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString(tagSpecificationTagsListValue.getKey()));
                        }
                        if (tagSpecificationTagsListValue.getValue() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString(tagSpecificationTagsListValue.getValue()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        if (createFlowLogsRequest.getMaxAggregationInterval() != null) {
            request.addParameter("MaxAggregationInterval", StringUtils.fromInteger(createFlowLogsRequest.getMaxAggregationInterval()));
        }
        if ((destinationOptions = createFlowLogsRequest.getDestinationOptions()) != null) {
            if (destinationOptions.getFileFormat() != null) {
                request.addParameter("DestinationOptions.FileFormat", StringUtils.fromString(destinationOptions.getFileFormat()));
            }
            if (destinationOptions.getHiveCompatiblePartitions() != null) {
                request.addParameter("DestinationOptions.HiveCompatiblePartitions", StringUtils.fromBoolean(destinationOptions.getHiveCompatiblePartitions()));
            }
            if (destinationOptions.getPerHourPartition() != null) {
                request.addParameter("DestinationOptions.PerHourPartition", StringUtils.fromBoolean(destinationOptions.getPerHourPartition()));
            }
        }
        return request;
    }
}

