/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.internal.SdkInternalList;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.CreateVerifiedAccessTrustProviderDeviceOptions;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.CreateVerifiedAccessTrustProviderOidcOptions;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.CreateVerifiedAccessTrustProviderRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.Tag;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.TagSpecification;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.VerifiedAccessSseSpecificationRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.IdempotentUtils;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;

public class CreateVerifiedAccessTrustProviderRequestMarshaller
implements Marshaller<Request<CreateVerifiedAccessTrustProviderRequest>, CreateVerifiedAccessTrustProviderRequest> {
    @Override
    public Request<CreateVerifiedAccessTrustProviderRequest> marshall(CreateVerifiedAccessTrustProviderRequest createVerifiedAccessTrustProviderRequest) {
        SdkInternalList createVerifiedAccessTrustProviderRequestTagSpecificationsList;
        CreateVerifiedAccessTrustProviderDeviceOptions deviceOptions;
        CreateVerifiedAccessTrustProviderOidcOptions oidcOptions;
        if (createVerifiedAccessTrustProviderRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateVerifiedAccessTrustProviderRequest> request = new DefaultRequest<CreateVerifiedAccessTrustProviderRequest>(createVerifiedAccessTrustProviderRequest, "AmazonEC2");
        request.addParameter("Action", "CreateVerifiedAccessTrustProvider");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createVerifiedAccessTrustProviderRequest.getTrustProviderType() != null) {
            request.addParameter("TrustProviderType", StringUtils.fromString(createVerifiedAccessTrustProviderRequest.getTrustProviderType()));
        }
        if (createVerifiedAccessTrustProviderRequest.getUserTrustProviderType() != null) {
            request.addParameter("UserTrustProviderType", StringUtils.fromString(createVerifiedAccessTrustProviderRequest.getUserTrustProviderType()));
        }
        if (createVerifiedAccessTrustProviderRequest.getDeviceTrustProviderType() != null) {
            request.addParameter("DeviceTrustProviderType", StringUtils.fromString(createVerifiedAccessTrustProviderRequest.getDeviceTrustProviderType()));
        }
        if ((oidcOptions = createVerifiedAccessTrustProviderRequest.getOidcOptions()) != null) {
            if (oidcOptions.getIssuer() != null) {
                request.addParameter("OidcOptions.Issuer", StringUtils.fromString(oidcOptions.getIssuer()));
            }
            if (oidcOptions.getAuthorizationEndpoint() != null) {
                request.addParameter("OidcOptions.AuthorizationEndpoint", StringUtils.fromString(oidcOptions.getAuthorizationEndpoint()));
            }
            if (oidcOptions.getTokenEndpoint() != null) {
                request.addParameter("OidcOptions.TokenEndpoint", StringUtils.fromString(oidcOptions.getTokenEndpoint()));
            }
            if (oidcOptions.getUserInfoEndpoint() != null) {
                request.addParameter("OidcOptions.UserInfoEndpoint", StringUtils.fromString(oidcOptions.getUserInfoEndpoint()));
            }
            if (oidcOptions.getClientId() != null) {
                request.addParameter("OidcOptions.ClientId", StringUtils.fromString(oidcOptions.getClientId()));
            }
            if (oidcOptions.getClientSecret() != null) {
                request.addParameter("OidcOptions.ClientSecret", StringUtils.fromString(oidcOptions.getClientSecret()));
            }
            if (oidcOptions.getScope() != null) {
                request.addParameter("OidcOptions.Scope", StringUtils.fromString(oidcOptions.getScope()));
            }
        }
        if ((deviceOptions = createVerifiedAccessTrustProviderRequest.getDeviceOptions()) != null) {
            if (deviceOptions.getTenantId() != null) {
                request.addParameter("DeviceOptions.TenantId", StringUtils.fromString(deviceOptions.getTenantId()));
            }
            if (deviceOptions.getPublicSigningKeyUrl() != null) {
                request.addParameter("DeviceOptions.PublicSigningKeyUrl", StringUtils.fromString(deviceOptions.getPublicSigningKeyUrl()));
            }
        }
        if (createVerifiedAccessTrustProviderRequest.getPolicyReferenceName() != null) {
            request.addParameter("PolicyReferenceName", StringUtils.fromString(createVerifiedAccessTrustProviderRequest.getPolicyReferenceName()));
        }
        if (createVerifiedAccessTrustProviderRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString(createVerifiedAccessTrustProviderRequest.getDescription()));
        }
        if (!(createVerifiedAccessTrustProviderRequestTagSpecificationsList = (SdkInternalList)createVerifiedAccessTrustProviderRequest.getTagSpecifications()).isEmpty() || !createVerifiedAccessTrustProviderRequestTagSpecificationsList.isAutoConstruct()) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification createVerifiedAccessTrustProviderRequestTagSpecificationsListValue : createVerifiedAccessTrustProviderRequestTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (createVerifiedAccessTrustProviderRequestTagSpecificationsListValue.getResourceType() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString(createVerifiedAccessTrustProviderRequestTagSpecificationsListValue.getResourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)createVerifiedAccessTrustProviderRequestTagSpecificationsListValue.getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.getKey() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString(tagSpecificationTagsListValue.getKey()));
                        }
                        if (tagSpecificationTagsListValue.getValue() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString(tagSpecificationTagsListValue.getValue()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        request.addParameter("ClientToken", IdempotentUtils.resolveString(createVerifiedAccessTrustProviderRequest.getClientToken()));
        VerifiedAccessSseSpecificationRequest sseSpecification = createVerifiedAccessTrustProviderRequest.getSseSpecification();
        if (sseSpecification != null) {
            if (sseSpecification.getCustomerManagedKeyEnabled() != null) {
                request.addParameter("SseSpecification.CustomerManagedKeyEnabled", StringUtils.fromBoolean(sseSpecification.getCustomerManagedKeyEnabled()));
            }
            if (sseSpecification.getKmsKeyArn() != null) {
                request.addParameter("SseSpecification.KmsKeyArn", StringUtils.fromString(sseSpecification.getKmsKeyArn()));
            }
        }
        return request;
    }
}

