/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.glue.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.annotation.SdkInternalApi;
import com.dataiku.dss.legacy.aws.com.amazonaws.protocol.MarshallLocation;
import com.dataiku.dss.legacy.aws.com.amazonaws.protocol.MarshallingInfo;
import com.dataiku.dss.legacy.aws.com.amazonaws.protocol.MarshallingType;
import com.dataiku.dss.legacy.aws.com.amazonaws.protocol.ProtocolMarshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.glue.model.S3Encryption;

@SdkInternalApi
public class S3EncryptionMarshaller {
    private static final MarshallingInfo<String> S3ENCRYPTIONMODE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3EncryptionMode").build();
    private static final MarshallingInfo<String> KMSKEYARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KmsKeyArn").build();
    private static final S3EncryptionMarshaller instance = new S3EncryptionMarshaller();

    public static S3EncryptionMarshaller getInstance() {
        return instance;
    }

    public void marshall(S3Encryption s3Encryption, ProtocolMarshaller protocolMarshaller) {
        if (s3Encryption == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(s3Encryption.getS3EncryptionMode(), S3ENCRYPTIONMODE_BINDING);
            protocolMarshaller.marshall(s3Encryption.getKmsKeyArn(), KMSKEYARN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

