/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.cli;

import com.dataiku.dip.server.SpringUtils;
import com.dataiku.fm.cli.FMInternalCLICommand;
import com.dataiku.fm.model.db.FMPersonalAPIKey;
import com.dataiku.fm.server.db.DatabaseAccessService;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.cli.CommandLine;

public class DeletePersonalKeyCommand
extends FMInternalCLICommand {
    private static final String[] ARG_NAMES = new String[]{"KEY_NAME"};

    @Override
    public String getUsageCommandName() {
        return "delete-personal-api-key";
    }

    @Override
    public String description() {
        return "Deletes a personal API key.";
    }

    @Override
    public String[] getUsageCommandArgs() {
        return ARG_NAMES;
    }

    @Override
    public int executeCommand(CommandLine commandLine) {
        Map<String, String> args = this.parseCmdArgs(commandLine, ARG_NAMES);
        String keyName = args.get("KEY_NAME");
        DatabaseAccessService dbService = (DatabaseAccessService)SpringUtils.getBean(DatabaseAccessService.class);
        try (DatabaseAccessService.ReadWriteTransaction t = dbService.rwTransaction();){
            FMPersonalAPIKey apiKey = Optional.ofNullable((FMPersonalAPIKey)t.getThreadEM().find(FMPersonalAPIKey.class, (Object)keyName)).orElseThrow(() -> new IllegalStateException(String.format("API Key with name '%s' does not exist.", keyName)));
            t.getThreadEM().remove((Object)apiKey);
            t.commit();
            System.out.println("API Key deleted.");
        }
        return 0;
    }
}

