/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.cloud.gcp;

import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.dataiku.fm.cloud.gcp.GCPClient;
import com.dataiku.fm.cloud.gcp.GCPException;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;

public class KMSClient
extends GCPClient {
    private static final String JSON_API = "https://cloudkms.googleapis.com/v1/";
    private static DKULogger logger = DKULogger.getLogger((String)"dku.kms.client");

    public KMSClient(GoogleCredential credentials, ProxySettings proxySettings, String userAgent) {
        super(credentials, proxySettings, userAgent);
    }

    @Override
    public String getApiRoot() {
        return JSON_API;
    }

    public List<String> listLocationIds(String projectId) throws GCPException {
        return this.listLocations(projectId).stream().map(l -> l.locationId).collect(Collectors.toList());
    }

    public List<Location> listLocations(String projectId) throws GCPException {
        return this.listAny(t -> this.listLocations(projectId, 0, t), p -> p.locations);
    }

    public LocationsPage listLocations(String projectId, int pageSize, String pageToken) throws GCPException {
        return this.listAny(projectId, "key rings", "locations", pageSize, pageToken, LocationsPage.class);
    }

    public List<String> listKeyRingNames(String projectId, String locationId) throws GCPException {
        return this.listAny(t -> this.listKeyRings(projectId, locationId, 0, t), p -> p.keyRings.stream().map(kr -> kr.name).collect(Collectors.toList()));
    }

    public KeyRingsPage listKeyRings(String projectId, String locationId, int pageSize, String pageToken) throws GCPException {
        return this.listAny(projectId, "key rings", "locations/" + locationId + "/keyRings", pageSize, pageToken, KeyRingsPage.class);
    }

    public List<CryptoKey> listCryptoKeys(String projectId, String locationId, String keyRing) throws GCPException {
        return this.listAny(t -> this.listCryptoKeys(projectId, locationId, keyRing, 0, t), p -> p.cryptoKeys);
    }

    public CryptoKeysPage listCryptoKeys(String projectId, String locationId, String keyRing, int pageSize, String pageToken) throws GCPException {
        return this.listAny(projectId, "key rings", "locations/" + locationId + "/keyRings/" + keyRing + "/cryptoKeys", pageSize, pageToken, CryptoKeysPage.class);
    }

    public String encryptUTF8(String projectId, String locationId, String keyRing, String key, String keyVersion, String data) throws IOException, GeneralSecurityException {
        CryptoKeyEncryptionRequest body = new CryptoKeyEncryptionRequest();
        body.plaintext = Base64.encodeBase64String((byte[])data.getBytes(StandardCharsets.UTF_8));
        String fullKey = StringUtils.isBlank((CharSequence)keyVersion) ? key : String.format("%s/cryptoKeyVersions/%s", key, keyVersion);
        CryptoKeyEncryptionResult result = this.sendPost(projectId, "locations/" + locationId + "/keyRings/" + keyRing + "/cryptoKeys/" + fullKey + ":encrypt", body, CryptoKeyEncryptionResult.class);
        return result.ciphertext;
    }

    public String decryptUTF8(String projectId, String locationId, String keyRing, String key, String data) throws IOException, GeneralSecurityException {
        CryptoKeyDecryptionRequest body = new CryptoKeyDecryptionRequest();
        body.ciphertext = data;
        CryptoKeyDecryptionResult result = this.sendPost(projectId, "locations/" + locationId + "/keyRings/" + keyRing + "/cryptoKeys/" + key + ":decrypt", body, CryptoKeyDecryptionResult.class);
        return new String(Base64.decodeBase64((String)result.plaintext), StandardCharsets.UTF_8);
    }

    public static class LocationsPage
    extends GCPClient.PagedList {
        public List<Location> locations;
        public int totalSize;
    }

    public static class KeyRingsPage
    extends GCPClient.PagedList {
        public List<KeyRing> keyRings;
        public int totalSize;
    }

    public static class CryptoKeysPage
    extends GCPClient.PagedList {
        public List<CryptoKey> cryptoKeys;
        public int totalSize;
    }

    public static class CryptoKeyEncryptionRequest {
        public String plaintext;
    }

    public static class CryptoKeyEncryptionResult {
        public String name;
        public String ciphertext;
        public String ciphertextCrc32c;
        public String protectionLevel;
        public boolean verifiedPlaintextCrc32c;
        public boolean verifiedAdditionalAuthenticatedDataCrc32c;
    }

    public static class CryptoKeyDecryptionRequest {
        public String ciphertext;
    }

    public static class CryptoKeyDecryptionResult {
        public String plaintext;
        public String plaintextCrc32c;
        public boolean usedPrimary;
        public String protectionLevel;
    }

    public static class KeyRing {
        public String name;
        public String createTime;
    }

    public static class Location {
        public String name;
        public String locationId;
        public String displayName;
        public Map<String, String> labels;
        public JsonObject metadata;
    }

    public static class CryptoKeyVersion {
        public String name;
        public String state;
        public String protectionLevel;
        public String algorithm;
        public String createTime;
        public String generateTime;
        public String destroyTime;
        public String destroyEventTime;
        public String importTime;
        public String importFailureReason;
        public JsonObject attestation;
        public JsonObject externalProtectionLevelOptions;
    }

    public static class CryptoKey {
        public String name;
        public String purpose;
        public CryptoKeyVersion primary;
        public String createTime;
        public String nextRotationTime;
        public String rotationPeriod;
        public Map<String, String> labels;
    }
}

