/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.model.db;

import com.dataiku.fm.model.db.InstanceSettingsTemplate;
import com.dataiku.fm.model.db.LogicalLoadBalancer;
import com.dataiku.fm.model.db.PhysicalInstance;
import com.dataiku.fm.model.db.Sublicense;
import com.dataiku.fm.model.db.Tenant;
import com.dataiku.fm.model.db.VirtualNetwork;
import com.dataiku.fm.model.published.CloudTagList;
import com.dataiku.fm.model.settings.FMSettings;
import com.dataiku.fm.server.FMApp;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToOne;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

@Entity(name="logicalinstance")
public class LogicalInstance {
    @Id
    private String id;
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private Tenant tenant;
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private VirtualNetwork virtualNetwork;
    @OneToOne(mappedBy="logicalInstance", fetch=FetchType.LAZY, optional=true)
    private PhysicalInstance currentPhysicalInstance;
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private InstanceSettingsTemplate instanceSettingsTemplate;
    private String label;
    @Column(columnDefinition="text")
    private String description;
    private String createdBy;
    private long creationDate;
    private String dssNodeType;
    private String externalURL;
    @Column(columnDefinition="text")
    private String fmTags;
    private Boolean singleNodeAsInfrastructure;
    @Enumerated(value=EnumType.STRING)
    private InstanceLicenseSelectionMode licenseSelectionMode = InstanceLicenseSelectionMode.GLOBAL;
    @ManyToOne(fetch=FetchType.LAZY, optional=true)
    private Sublicense sublicense;
    private String imageId;
    private String cloudInstanceType;
    private int dataVolumeSizeGB;
    private int dataVolumeSizeMaxGB;
    private String dataVolumeType;
    private Integer dataVolumeIOPS;
    private boolean encryptDataVolume;
    private String dataVolumeEncryptionKey;
    private Boolean encryptRootVolume;
    private Integer awsRootVolumeSizeGB;
    private boolean enableAutomatedSnapshot;
    private int automatedSnapshotPeriod;
    private int automatedSnapshotRetention;
    @Column(columnDefinition="text")
    private String cloudTags;
    private boolean awsAssignElasticIP;
    private String awsElasticIPAllocationId;
    private String awsRootVolumeType;
    private Integer awsRootVolumeIOPS;
    private String awsPrivateIP;
    private boolean azureAssignPublicIP;
    private String azurePublicIPId;
    private String azurePrivateIP;
    private String azureInstanceName;
    private String azureDataVolumeName;
    private String azureOSVolumeName;
    private String azureNicName;
    private String azurePublicIPName;
    private String azureAvailabilityZone;
    private String azureRGForSnapshots;
    private String gcpZone;
    private String gcpPrivateIP;
    private Boolean gcpAssignPublicIP;
    private String gcpPublicIPId;
    private String gcpInstanceName;
    private String gcpDataVolumeName;
    private String additionalDomainNamesForCertificate;
    @Column(columnDefinition="text")
    private String sslCertificatePEM;
    @Enumerated(value=EnumType.STRING)
    private CustomCertificateKeyStorageMode sslCertificateKeyStorageMode;
    @Column(columnDefinition="text")
    private String sslCertificateKeyPEM;
    private String sslCertificateAwsSecretName;
    private String azureSSLCertificateSecretName;
    private String azureSSLCertificateSecretVersion;
    private String azureKeyvaultUrl;
    private String azureSSLCertificateName;
    private String azureSSLCertificateVersion;
    private InstanceSettingsTemplate.CertificateContentType azureSSLCertificateContentType;
    private String azureUserAssignedManagedServiceIdentity;
    private String sslCertificateGcpSecretId;
    @Deprecated
    private String agentSecret;
    @Deprecated
    private String adminAPIKey;
    @Deprecated
    private String eventServerAuthKey;
    @Column(columnDefinition="text")
    private String agentSecretEnc;
    @Column(columnDefinition="text")
    private String adminAPIKeyEnc;
    @Column(columnDefinition="text")
    private String eventServerAuthKeyEnc;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Tenant getTenant() {
        return this.tenant;
    }

    public void setTenant(Tenant tenant) {
        this.tenant = tenant;
    }

    public String getAgentSecret() {
        if (StringUtils.isNotBlank((String)this.agentSecretEnc)) {
            return this.agentSecretEnc;
        }
        return this.agentSecret;
    }

    public void setAgentSecret(String agentSecret) {
        this.agentSecretEnc = agentSecret;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public long getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(long creationDate) {
        this.creationDate = creationDate;
    }

    public String getAdminAPIKey() {
        if (StringUtils.isNotBlank((String)this.adminAPIKeyEnc)) {
            return this.adminAPIKeyEnc;
        }
        return this.adminAPIKey;
    }

    public void setAdminAPIKey(String adminAPIKey) {
        this.adminAPIKeyEnc = adminAPIKey;
    }

    public VirtualNetwork getVirtualNetwork() {
        return this.virtualNetwork;
    }

    public void setVirtualNetwork(VirtualNetwork virtualNetwork) {
        this.virtualNetwork = virtualNetwork;
    }

    public PhysicalInstance getCurrentPhysicalInstance() {
        return this.currentPhysicalInstance;
    }

    public void setCurrentPhysicalInstance(PhysicalInstance currentPhysicalInstance) {
        this.currentPhysicalInstance = currentPhysicalInstance;
    }

    public String getDssNodeType() {
        return this.dssNodeType;
    }

    public void setDssNodeType(String dssNodeType) {
        this.dssNodeType = dssNodeType;
    }

    public String getExternalURL() {
        return this.externalURL;
    }

    public void setExternalURL(String externalURL) {
        this.externalURL = externalURL;
    }

    public String getImageId() {
        return this.imageId;
    }

    public void setImageId(String imageId) {
        this.imageId = imageId;
    }

    public String getCloudInstanceType() {
        return this.cloudInstanceType;
    }

    public void setCloudInstanceType(String cloudInstanceType) {
        this.cloudInstanceType = cloudInstanceType;
    }

    public String getDataVolumeType() {
        return this.dataVolumeType;
    }

    public void setDataVolumeType(String dataVolumeType) {
        this.dataVolumeType = dataVolumeType;
    }

    public int getDataVolumeSizeGB() {
        return this.dataVolumeSizeGB;
    }

    public void setDataVolumeSizeGB(int dataVolumeSizeGB) {
        this.dataVolumeSizeGB = dataVolumeSizeGB;
    }

    public int getDataVolumeSizeMaxGB() {
        return this.dataVolumeSizeMaxGB;
    }

    public void setDataVolumeSizeMaxGB(int dataVolumeSizeMaxGB) {
        this.dataVolumeSizeMaxGB = dataVolumeSizeMaxGB;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public InstanceSettingsTemplate getInstanceSettingsTemplate() {
        return this.instanceSettingsTemplate;
    }

    public void setInstanceSettingsTemplate(InstanceSettingsTemplate instanceSettingsTemplate) {
        this.instanceSettingsTemplate = instanceSettingsTemplate;
    }

    public boolean isAwsAssignElasticIP() {
        return this.awsAssignElasticIP;
    }

    public void setAwsAssignElasticIP(boolean awsAssignElasticIP) {
        this.awsAssignElasticIP = awsAssignElasticIP;
    }

    public String getAwsElasticIPAllocationId() {
        return this.awsElasticIPAllocationId;
    }

    public void setAwsElasticIPAllocationId(String awsElasticIPAllocationId) {
        this.awsElasticIPAllocationId = awsElasticIPAllocationId;
    }

    public String getFMTags() {
        return this.fmTags;
    }

    public void setFMTags(String fmTags) {
        this.fmTags = fmTags;
    }

    public boolean getEnableAutomatedSnapshot() {
        return this.enableAutomatedSnapshot;
    }

    public void setEnableAutomatedSnapshot(boolean enableAutomatedSnapshot) {
        this.enableAutomatedSnapshot = enableAutomatedSnapshot;
    }

    public int getAutomatedSnapshotPeriod() {
        return this.automatedSnapshotPeriod;
    }

    public void setAutomatedSnapshotPeriod(int automatedSnapshotPeriod) {
        this.automatedSnapshotPeriod = automatedSnapshotPeriod;
    }

    public int getAutomatedSnapshotRetention() {
        return this.automatedSnapshotRetention;
    }

    public void setAutomatedSnapshotRetention(int automatedSnapshotRetention) {
        this.automatedSnapshotRetention = automatedSnapshotRetention;
    }

    public String getAdditionalDomainNamesForCertificate() {
        return this.additionalDomainNamesForCertificate;
    }

    public void setAdditionalDomainNamesForCertificate(String additionalDomainNamesForCertificate) {
        this.additionalDomainNamesForCertificate = additionalDomainNamesForCertificate;
    }

    public String getSslCertificatePEM() {
        return this.sslCertificatePEM;
    }

    public void setSslCertificatePEM(String sslCertificatePEM) {
        this.sslCertificatePEM = sslCertificatePEM;
    }

    public CustomCertificateKeyStorageMode getSslCertificateKeyStorageMode() {
        return this.sslCertificateKeyStorageMode;
    }

    public void setSslCertificateKeyStorageMode(CustomCertificateKeyStorageMode sslCertificateKeyStorageMode) {
        this.sslCertificateKeyStorageMode = sslCertificateKeyStorageMode;
    }

    public String getSslCertificateKeyPEM() {
        return this.sslCertificateKeyPEM;
    }

    public void setSslCertificateKeyPEM(String sslCertificateKeyPEM) {
        this.sslCertificateKeyPEM = sslCertificateKeyPEM;
    }

    public String getSslCertificateAwsSecretName() {
        return this.sslCertificateAwsSecretName;
    }

    public void setSslCertificateAwsSecretName(String sslCertificateAwsSecretName) {
        this.sslCertificateAwsSecretName = sslCertificateAwsSecretName;
    }

    public String getSslCertificateGcpSecretId() {
        return this.sslCertificateGcpSecretId;
    }

    public void setSslCertificateGcpSecretId(String sslCertificateGcpSecretId) {
        this.sslCertificateGcpSecretId = sslCertificateGcpSecretId;
    }

    public String getAzureSSLCertificateSecretName() {
        return this.azureSSLCertificateSecretName;
    }

    public void setAzureSSLCertificateSecretName(String azureSSLCertificateSecretName) {
        this.azureSSLCertificateSecretName = azureSSLCertificateSecretName;
    }

    public String getAzureSSLCertificateSecretVersion() {
        return this.azureSSLCertificateSecretVersion;
    }

    public void setAzureSSLCertificateSecretVersion(String azureSSLCertificateSecretVersion) {
        this.azureSSLCertificateSecretVersion = azureSSLCertificateSecretVersion;
    }

    public String getAzureKeyvaultUrl() {
        return this.azureKeyvaultUrl;
    }

    public void setAzureKeyvaultUrl(String azureKeyvaultUrl) {
        this.azureKeyvaultUrl = azureKeyvaultUrl;
    }

    public CustomCertificateKeyStorageMode getSSLCertificateKeyStorageMode() {
        return this.sslCertificateKeyStorageMode;
    }

    public String getAzureSSLCertificateName() {
        return this.azureSSLCertificateName;
    }

    public String getAzureSSLCertificateVersion() {
        return this.azureSSLCertificateVersion;
    }

    public InstanceSettingsTemplate.CertificateContentType getAzureSSLCertificateContentType() {
        return this.azureSSLCertificateContentType;
    }

    public void setSSLCertificateKeyStorageMode(CustomCertificateKeyStorageMode sslCertificateKeyStorageMode) {
        this.sslCertificateKeyStorageMode = sslCertificateKeyStorageMode;
    }

    public void setAzureSSLCertificateName(String azureSSLCertificateName) {
        this.azureSSLCertificateName = azureSSLCertificateName;
    }

    public void setAzureSSLCertificateVersion(String azureSSLCertificateVersion) {
        this.azureSSLCertificateVersion = azureSSLCertificateVersion;
    }

    public void setAzureSSLCertificateContentType(InstanceSettingsTemplate.CertificateContentType azureSSLCertificateContentType) {
        this.azureSSLCertificateContentType = azureSSLCertificateContentType;
    }

    public String getAzureUserAssignedManagedServiceIdentity() {
        return this.azureUserAssignedManagedServiceIdentity;
    }

    public String getCloudTags() {
        return this.cloudTags;
    }

    public void setCloudTags(String cloudTags) {
        this.cloudTags = cloudTags;
    }

    public boolean isAzureAssignPublicIP() {
        return this.azureAssignPublicIP;
    }

    public void setAzureAssignPublicIP(boolean azureAssignPublicIP) {
        this.azureAssignPublicIP = azureAssignPublicIP;
    }

    public String getAzurePublicIPId() {
        return this.azurePublicIPId;
    }

    public void setAzurePublicIPId(String azurePublicIPId) {
        this.azurePublicIPId = azurePublicIPId;
    }

    public String getGcpZone() {
        return this.gcpZone;
    }

    public void setGcpZone(String gcpZone) {
        this.gcpZone = gcpZone;
    }

    public String getGcpPrivateIP() {
        return this.gcpPrivateIP;
    }

    public void setGcpPrivateIP(String gcpPrivateIP) {
        this.gcpPrivateIP = gcpPrivateIP;
    }

    public String getGcpPublicIPId() {
        return this.gcpPublicIPId;
    }

    public void setGcpPublicIPId(String gcpPublicIPId) {
        this.gcpPublicIPId = gcpPublicIPId;
    }

    public boolean isGcpAssignPublicIP() {
        return this.gcpAssignPublicIP != null && this.gcpAssignPublicIP != false;
    }

    public void setGcpAssignPublicIP(boolean gcpAssignPublicIP) {
        this.gcpAssignPublicIP = gcpAssignPublicIP;
    }

    public String getGcpInstanceName() {
        return this.gcpInstanceName;
    }

    public void setGcpInstanceName(String gcpInstanceName) {
        this.gcpInstanceName = gcpInstanceName;
    }

    public String getGcpDataVolumeName() {
        return this.gcpDataVolumeName;
    }

    public void setGcpDataVolumeName(String gcpDataVolumeName) {
        this.gcpDataVolumeName = gcpDataVolumeName;
    }

    public String getAzurePublicIPName() {
        return this.azurePublicIPName;
    }

    public void setAzurePublicIPName(String azurePublicIPName) {
        this.azurePublicIPName = azurePublicIPName;
    }

    public String getAzureAvailabilityZone() {
        return this.azureAvailabilityZone;
    }

    public void setAzureAvailabilityZone(String azureAvailabilityZone) {
        this.azureAvailabilityZone = azureAvailabilityZone;
    }

    @Nullable
    public String getAzureRGForSnapshots() {
        return this.azureRGForSnapshots;
    }

    public void setAzureRGForSnapshots(String azureRGForSnapshots) {
        this.azureRGForSnapshots = azureRGForSnapshots;
    }

    public String getAzurePrivateIP() {
        return this.azurePrivateIP;
    }

    public void setAzurePrivateIP(String azurePrivateIP) {
        this.azurePrivateIP = azurePrivateIP;
    }

    public String getAzureInstanceName() {
        return this.azureInstanceName;
    }

    public void setAzureInstanceName(String azureInstanceName) {
        this.azureInstanceName = azureInstanceName;
    }

    public String getAzureDataVolumeName() {
        return this.azureDataVolumeName;
    }

    public void setAzureDataVolumeName(String azureDataVolumeName) {
        this.azureDataVolumeName = azureDataVolumeName;
    }

    public String getAzureOSVolumeName() {
        return this.azureOSVolumeName;
    }

    public void setAzureOSVolumeName(String azureOSVolumeName) {
        this.azureOSVolumeName = azureOSVolumeName;
    }

    public String getAzureNicName() {
        return this.azureNicName;
    }

    public void setAzureNicName(String azureNicName) {
        this.azureNicName = azureNicName;
    }

    public Integer getDataVolumeIOPS() {
        return this.dataVolumeIOPS;
    }

    public void setDataVolumeIOPS(Integer dataVolumeIOPS) {
        this.dataVolumeIOPS = dataVolumeIOPS;
    }

    public Integer getRootVolumeSizeGB() {
        return this.awsRootVolumeSizeGB;
    }

    public void setRootVolumeSizeGB(Integer rootVolumeSizeGB) {
        this.awsRootVolumeSizeGB = rootVolumeSizeGB;
    }

    public String getAwsRootVolumeType() {
        return this.awsRootVolumeType;
    }

    public void setAwsRootVolumeType(String awsRootVolumeType) {
        this.awsRootVolumeType = awsRootVolumeType;
    }

    public Integer getAwsRootVolumeIOPS() {
        return this.awsRootVolumeIOPS;
    }

    public void setAwsRootVolumeIOPS(Integer awsRootVolumeIOPS) {
        this.awsRootVolumeIOPS = awsRootVolumeIOPS;
    }

    public String getAwsPrivateIP() {
        return this.awsPrivateIP;
    }

    public void setAwsPrivateIP(String awsPrivateIP) {
        this.awsPrivateIP = awsPrivateIP;
    }

    public boolean getEncryptDataVolume() {
        return this.encryptDataVolume;
    }

    public void setEncryptDataVolume(boolean encryptDataVolume) {
        this.encryptDataVolume = encryptDataVolume;
    }

    public String getDataVolumeEncryptionKey() {
        return this.dataVolumeEncryptionKey;
    }

    public void setDataVolumeEncryptionKey(String dataVolumeEncryptionKey) {
        this.dataVolumeEncryptionKey = dataVolumeEncryptionKey;
    }

    public boolean getEncryptRootVolume() {
        return this.encryptRootVolume != null && this.encryptRootVolume != false;
    }

    public void setEncryptRootVolume(boolean encryptRootVolume) {
        this.encryptRootVolume = encryptRootVolume;
    }

    public String getEventServerAuthKey() {
        if (StringUtils.isNotBlank((String)this.eventServerAuthKeyEnc)) {
            return this.eventServerAuthKeyEnc;
        }
        return this.eventServerAuthKey;
    }

    public void setEventServerAuthKey(String eventServerAuthKey) {
        this.eventServerAuthKeyEnc = eventServerAuthKey;
    }

    public InstanceLicenseSelectionMode getLicenseSelectionMode() {
        return this.licenseSelectionMode;
    }

    public void setLicenseSelectionMode(InstanceLicenseSelectionMode licenseSelectionMode) {
        this.licenseSelectionMode = licenseSelectionMode;
    }

    public Sublicense getSublicense() {
        return this.sublicense;
    }

    public void setSublicense(Sublicense sublicense) {
        this.sublicense = sublicense;
    }

    public boolean isAzureAvailabilityZoneSpecified() {
        return StringUtils.isNotBlank((String)this.azureAvailabilityZone);
    }

    public Boolean getSingleNodeAsInfrastructure() {
        return this.singleNodeAsInfrastructure;
    }

    public void setSingleNodeAsInfrastructure(Boolean singleNodeAsInfrastructure) {
        this.singleNodeAsInfrastructure = singleNodeAsInfrastructure;
    }

    public CloudTagList getInheritedCloudTags(LogicalLoadBalancer loadBalancer) {
        FMSettings settings = FMApp.getFMSettingsUnsafe();
        return loadBalancer == null ? this.virtualNetwork.getInheritedCloudTags(settings).with(CloudTagList.fromJSON(this.virtualNetwork.getCloudTags())) : loadBalancer.getInheritedCloudTags(settings).with(CloudTagList.fromJSON(loadBalancer.getCloudTags()));
    }

    public CloudTagList getCloudApplicableTags(LogicalLoadBalancer loadBalancer) {
        FMSettings settings = FMApp.getFMSettingsUnsafe();
        CloudTagList tagsList = loadBalancer == null ? this.virtualNetwork.getCloudApplicableTags(settings) : loadBalancer.getCloudApplicableTags(settings);
        tagsList = tagsList.with(CloudTagList.fromJSON(this.getCloudTags()));
        if (this.currentPhysicalInstance != null) {
            tagsList = tagsList.with("fm:physicalInstanceId", this.currentPhysicalInstance.getId());
        }
        return tagsList.with("fm:logicalInstanceId", this.getId());
    }

    public static enum InstanceLicenseSelectionMode {
        GLOBAL,
        EXPLICIT_SUBLICENSE;

    }

    public static enum CustomCertificateKeyStorageMode {
        SELF_SIGNED,
        INLINE_ENCRYPTED,
        SECRETS_MANAGER,
        CERTIFICATE_MANAGER;

    }
}

