/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.alerts;

import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.fm.model.published.AlertingConfigurationDTO;
import com.dataiku.fm.model.published.ProtoAlertingConfiguration;
import com.dataiku.fm.security.FMAuthCtx;
import com.dataiku.fm.server.alerts.AlertingUIService;
import com.dataiku.fm.server.security.FMPermissionsService;
import com.dataiku.fm.server.security.FMUIAuthService;
import com.dataiku.fm.utils.APIInputValidator;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class AlertingController
extends DIPInternalControllerBase {
    @Autowired
    private FMUIAuthService uiAuthService;
    @Autowired
    private FMPermissionsService permissionsService;
    @Autowired
    private AlertingUIService alertingUIService;

    @RequestMapping(value={"/api/ui/alerting"}, method={RequestMethod.GET})
    public void get(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        String tenantId = authCtx.getTenantId();
        AlertingConfigurationDTO alertingDTO = this.alertingUIService.list(tenantId);
        AlertingController.writeJSON((HttpServletResponse)resp, (Object)alertingDTO);
    }

    @RequestMapping(value={"/api/ui/alerting"}, method={RequestMethod.PUT})
    public void update(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        ProtoAlertingConfiguration protoAlerting = (ProtoAlertingConfiguration)this.getRequestBodyAs(req, ProtoAlertingConfiguration.class);
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        APIInputValidator.checkListNotEmpty(protoAlerting.messagingChannels, "At least one messaging channel expected", new Object[0]);
        APIInputValidator.checkListNotEmpty(protoAlerting.checkReporters, "At least one check reporter expected", new Object[0]);
        String tenantId = authCtx.getTenantId();
        AlertingConfigurationDTO alertingDTO = this.alertingUIService.update(tenantId, protoAlerting);
        AlertingController.writeJSON((HttpServletResponse)resp, (Object)alertingDTO);
    }
}

