/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.instances;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JF;
import com.dataiku.dip.utils.JSON;
import com.dataiku.fm.model.db.LogicalInstance;
import com.dataiku.fm.model.db.LogicalInstanceEvent;
import com.dataiku.fm.server.db.DatabaseAccessService;
import com.dataiku.fm.server.instances.InstancesCRUDService;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InstancesEventLogService {
    @Autowired
    private DatabaseAccessService dbService;
    @Autowired
    private InstancesCRUDService crudService;
    private ExecutorService es = Executors.newSingleThreadExecutor();
    private static DKULogger logger = DKULogger.getLogger((String)"dku.fm.instances");

    public void addEventSync(DatabaseAccessService.ReadWriteTransaction rwt, LogicalInstance li, AuthCtx authCtx, String eventType, JF.ObjectBuilder obj) {
        this.addEventSync(rwt, li, authCtx, eventType, obj.get());
    }

    public void addEventASync_NT(LogicalInstance li, AuthCtx authCtx, String eventType, JF.ObjectBuilder obj) {
        this.addEventASync_NT(li, authCtx, eventType, obj.get());
    }

    public void addEventASync_NT(String tenantId, String instanceId, AuthCtx authCtx, String eventType, JF.ObjectBuilder obj) {
        LogicalInstance li = this.crudService.getInternal(tenantId, instanceId);
        this.addEventASync_NT(li, authCtx, eventType, obj.get());
    }

    public void addEventSync(DatabaseAccessService.ReadWriteTransaction rwt, LogicalInstance li, AuthCtx authCtx, String eventType, JsonObject obj) {
        LogicalInstanceEvent lie = new LogicalInstanceEvent();
        lie.setLogicalInstance(li);
        lie.setTimestamp(System.currentTimeMillis());
        lie.setEventType(eventType);
        if (obj != null) {
            lie.setEventPayload(JSON.json((Object)obj));
        }
        rwt.getThreadEM().persist((Object)lie);
    }

    public void addEventASync_NT(LogicalInstance li, AuthCtx authCtx, final String eventType, final JsonObject obj) {
        final String tenantId = li.getTenant().getId();
        final String liId = li.getId();
        this.es.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try (DatabaseAccessService.ReadWriteTransaction rwt = InstancesEventLogService.this.dbService.rwTransaction();){
                    LogicalInstance li = InstancesEventLogService.this.crudService.getInternal(tenantId, liId);
                    InstancesEventLogService.this.addEventSync(rwt, li, null, eventType, obj);
                    rwt.commit();
                }
                return null;
            }
        });
    }

    public LogicalInstanceEventsLogDTO getInstanceLog(LogicalInstance li, int limit) {
        LogicalInstanceEventsLogDTO ret = new LogicalInstanceEventsLogDTO();
        for (LogicalInstanceEvent lie : this.dbService.listResults(LogicalInstanceEvent.class, limit, "SELECT lie from logicalinstanceevent lie where lie.logicalInstance=?1 order by timestamp desc", li)) {
            ret.events.add(this.toDTO(lie));
        }
        return ret;
    }

    private LogicalInstanceEventDTO toDTO(LogicalInstanceEvent lie) {
        LogicalInstanceEventDTO dto = new LogicalInstanceEventDTO();
        if (lie.getEventPayload() != null) {
            dto.eventPayload = (JsonObject)JSON.parse((String)lie.getEventPayload(), JsonObject.class);
        }
        dto.eventType = lie.getEventType();
        dto.timestamp = lie.getTimestamp();
        return dto;
    }

    public static class LogicalInstanceEventsLogDTO {
        public List<LogicalInstanceEventDTO> events = new ArrayList<LogicalInstanceEventDTO>();
    }

    public static class LogicalInstanceEventDTO {
        public long timestamp;
        public String eventType;
        public JsonObject eventPayload;
    }
}

