/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.logging;

import com.dataiku.dip.classpathfix.DKULongs;
import com.dataiku.dip.utils.DKUDateUtils;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Layout;
import org.apache.log4j.MDC;
import org.apache.log4j.spi.LoggingEvent;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONAuditLayout
extends Layout {
    private Pattern pattern = Pattern.compile("\\[ct: ([0-9]*)\\] ");

    public void activateOptions() {
    }

    public String format(LoggingEvent evt) {
        JSONObject object = new JSONObject();
        try {
            Matcher m;
            object.put("timestamp", (Object)DKUDateUtils.isoFormatLocal((long)evt.timeStamp));
            object.put("logger", (Object)evt.getLoggerName());
            object.put("severity", (Object)evt.getLevel().toString());
            String msg = evt.getMessage() == null ? "{}" : evt.getMessage().toString();
            object.put("message", (Object)msg);
            if (msg.startsWith("[ct") && (m = this.pattern.matcher(msg)).find()) {
                String ct = m.group(1);
                msg = m.replaceAll("");
                object.put("callTime", (Object)DKULongs.tryParse((String)ct));
            }
            try {
                JSONObject jo = new JSONObject(msg);
                if (jo.has("auditTopic")) {
                    object.put("topic", (Object)jo.getString("auditTopic"));
                }
                object.put("message", (Object)jo);
            }
            catch (Exception e) {
                System.err.println("Failed to parse JSON payload from message: " + msg);
                e.printStackTrace();
            }
            JSONObject mdc = new JSONObject();
            if (MDC.getContext() != null) {
                for (Object _k : Collections.list(MDC.getContext().keys())) {
                    if (_k == null || _k.toString() == null || _k.toString().startsWith("_")) continue;
                    mdc.put(_k.toString(), (Object)MDC.get((String)_k.toString()).toString());
                }
                object.put("mdc", (Object)mdc);
            }
            return object.toString() + "\n";
        }
        catch (JSONException e) {
            System.err.println("Failed to format message");
            e.printStackTrace();
            return null;
        }
    }

    public boolean ignoresThrowable() {
        return true;
    }
}

