/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.transactions.fs.utils.copy;

import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.ifaces.ReadOnlyFS;
import com.dataiku.dip.transactions.fs.ifaces.ReadWriteFS;
import com.dataiku.dip.transactions.fs.ifaces.RelFileAttribute;
import com.dataiku.dip.transactions.fs.utils.FSUtils;
import com.dataiku.dip.transactions.fs.utils.copy.CopyMethod;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public class ParallelizedCopyMethod
implements CopyMethod {
    private final ConcurrentHashMap<Thread, CopyMethod> perThreadCopyMethod;
    private final ExecutorService executorService;
    private final Supplier<CopyMethod> copyMethodSupplier;
    private IOException firstException = null;

    public ParallelizedCopyMethod(int nbThreads, int queueSize, Supplier<CopyMethod> copyMethodSupplier) {
        this.copyMethodSupplier = copyMethodSupplier;
        this.perThreadCopyMethod = new ConcurrentHashMap();
        this.executorService = new ThreadPoolExecutor(nbThreads, nbThreads, Long.MAX_VALUE, TimeUnit.NANOSECONDS, new LinkedBlockingQueue<Runnable>(queueSize), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    @Override
    public void copyFile(ReadOnlyFS srcFS, RelFile srcFile, @Nullable RelFileAttribute srcAttr, ReadWriteFS dstFS, RelFile dstFile, @Nullable RelFileAttribute dstAttr) throws IOException {
        this.checkError();
        this.executorService.execute(() -> {
            try {
                this.checkError();
                Thread currentThread = Thread.currentThread();
                CopyMethod copyMethod = this.perThreadCopyMethod.get(currentThread);
                if (copyMethod == null) {
                    copyMethod = this.copyMethodSupplier.get();
                }
                this.perThreadCopyMethod.put(currentThread, copyMethod);
                copyMethod.copyFile(srcFS, srcFile, srcAttr, dstFS, dstFile, dstAttr);
            }
            catch (Exception e) {
                this.setError(new IOException("Error while copying \"" + String.valueOf(srcFile) + "\" to \"" + String.valueOf(dstFile) + "\" (" + e.getMessage() + ")", e));
            }
        });
    }

    private synchronized void setError(IOException e) {
        if (this.firstException == null) {
            this.firstException = e;
        }
    }

    private synchronized void checkError() throws IOException {
        if (this.firstException != null) {
            throw this.firstException;
        }
    }

    @Override
    public FSUtils.CopyStats getStats() {
        return this.perThreadCopyMethod.values().stream().map(CopyMethod::getStats).reduce(new FSUtils.CopyStats(), FSUtils.CopyStats::aggregate);
    }

    @Override
    public void close() throws IOException {
        this.executorService.shutdown();
        try {
            while (!this.executorService.awaitTermination(1L, TimeUnit.MINUTES)) {
            }
        }
        catch (InterruptedException e) {
            this.executorService.shutdownNow();
            Thread.currentThread().interrupt();
            this.checkError();
            throw new IOException("Interrupted while copying files", e);
        }
        finally {
            for (CopyMethod copyMethod : this.perThreadCopyMethod.values()) {
                IOUtils.closeQuietly((Closeable)copyMethod);
            }
        }
        this.checkError();
    }
}

