import numpy as np


# Python translation of nice bounds logic in NumericalVariableAnalyzer (in DSS charts)
def nice_bounds(vmin, vmax, nb_bins):
    span = vmax - vmin
    if span < np.finfo(float).eps:
        span = 1

    ln10 = np.log(10)
    step = 10 ** np.floor(np.log(span / nb_bins) / ln10)
    err = nb_bins / span * step

    if err <= .15:
        step *= 10
    elif err <= .35:
        step *= 5
    elif err <= .75:
        step *= 2

    fixed_min = np.floor(vmin / step) * step
    fixed_max = np.ceil(vmax / step) * step

    if fixed_min + nb_bins * step < fixed_max:
        step = (fixed_max - fixed_min) / nb_bins

    return fixed_min, step * nb_bins + fixed_min


def nice_bin_edges(series, nb_bins):
    vmin = 0
    vmax = 0
    if len(series) > 0:
        vmin = np.min(series)
        vmax = np.max(series)

    fixed_vmin, fixed_vmax = nice_bounds(vmin, vmax, nb_bins)

    # The bins are right exclusive
    # If necessary, virtually extend the range so that the last value is always included
    if fixed_vmax == vmax:
        offset = (fixed_vmax - fixed_vmin) / (2 * nb_bins)  # This is an arbitrary choice
        fixed_vmin, fixed_vmax = nice_bounds(fixed_vmin, fixed_vmax + offset, nb_bins)

    return np.linspace(fixed_vmin, fixed_vmax, nb_bins + 1)
