/* global describe, it, xit, beforeEach, ChartFeaturesTestUtils */

describe('chart features grouped_columns', function () {

    const chartType = 'grouped_columns';
    const chartVariant = 'normal';

    /* Get tests helpers */
    const { expectIdToBeVisible, expectIdToBeHidden, renderTemplate } = ChartFeaturesTestUtils;

    /* Initialize each test */
    beforeEach(() => {
        ChartFeaturesTestUtils.initEachTest();
        ChartFeaturesTestUtils.initChartType(chartType, chartVariant);
        ChartFeaturesTestUtils.setAxisSpecs(chartType);
    });

    it('has left menu filters dropzone', function () {
        renderTemplate('/templates/simple_report/left-column/left-column.html');

        expectIdToBeVisible('qa_charts_filter-submenu-header');
        expectIdToBeVisible('qa_charts_filters-dropzone');
    })

    it('has left menu dimensions options', function () {
        renderTemplate('/templates/simple_report/left-column/dimensions.html');

        expectIdToBeVisible('qa_charts_tooltip-submenu-header');
        expectIdToBeVisible('qa_charts_animation-submenu-header');
        expectIdToBeVisible('qa_charts_animation-dropzone');
        expectIdToBeVisible('qa_charts_subchart-submenu-header');
        expectIdToBeVisible('qa_charts_subcharts-dropzone');
    })

    it('has axis options', function () {
        ChartFeaturesTestUtils.setXYGenericFromNumericalColumns();
        renderTemplate(`/templates/simple_report/types/definition-${chartType}.html`);

        $('.measure-wrapper')[0].click(); // in Y
        expectIdToBeVisible('qa_charts_multi-y-axis-select');
        expectIdToBeHidden('qa_charts_multiplot-mode-select');
        expectIdToBeVisible('qa_charts_computation-type-select');

        $('.measure-wrapper')[1].click() // in X
        expectIdToBeVisible('qa_charts_one-tick-per-bin-select');
        expectIdToBeHidden('qa_charts_handling-empty-bins-select');
    })

    it('doesn\'t have along dimension option with compute mode NORMAL', function () {
        ChartFeaturesTestUtils.computeAlongDimensionSelectTests(chartType, 'NORMAL', false);
    })

    it('has along dimension option with compute mode PERCENTAGE', function () {
        ChartFeaturesTestUtils.computeAlongDimensionSelectTests(chartType, 'PERCENTAGE');
    })

    it('has along dimension option with compute mode CUMULATIVE_PERCENTAGE', function () {
        ChartFeaturesTestUtils.computeAlongDimensionSelectTests(chartType, 'CUMULATIVE_PERCENTAGE');
    })

    it('doesn\'t have along dimension option with compute mode CUMULATIVE', function () {
        ChartFeaturesTestUtils.computeAlongDimensionSelectTests(chartType, 'CUMULATIVE', false);
    })

    it('has along dimension option with compute mode AVG_RATIO', function () {
        ChartFeaturesTestUtils.computeAlongDimensionSelectTests(chartType, 'AVG_RATIO');
    })

    it('doesn\'t have regression line options', function () {
        renderTemplate(`/templates/simple_report/types/options-${chartType}.html`);
        expectIdToBeHidden('qa_charts_regression-line-form');
    })

});
