import json
import pandas as pd
import logging

from dataiku.external_ml.proxy_model.common.outputformat import BaseReader

logger = logging.getLogger(__name__)


class AzureMLJSONArrayReader(BaseReader):
    NAME = "OUTPUT_AZUREML_JSON_ARRAY"

    def __init__(self, prediction_type, value_to_class):
        super(AzureMLJSONArrayReader, self).__init__(prediction_type, value_to_class)

    def can_read(self, endpoint_output):
        try:
            as_json = json.loads(endpoint_output)
            if isinstance(as_json, list):
                df = pd.DataFrame(as_json)
                if len(df.columns) == 1:
                    logger.info("Predictions are in JSON array format")
                    return True
            logger.info("Predictions are not in JSON array format")
            return False
        except json.JSONDecodeError as json_exception:
            logger.info("Predictions are not in JSON array format")
            logger.debug("JSON Parse exception: {}".format(json_exception))
            return False

    def _read(self, endpoint_output):
        as_json = json.loads(endpoint_output)
        return pd.DataFrame({"prediction": as_json})

    def read_binary(self, endpoint_output):
        return self._read(endpoint_output)

    def read_multiclass(self, endpoint_output):
        return self._read(endpoint_output)

    def read_regression(self, endpoint_output):
        return self._read(endpoint_output)

