from abc import abstractmethod

from dataiku.external_ml.proxy_model.common.inputformat import BaseWriter


class AbstractSagemakerWriter(BaseWriter):
    NAME = "INPUT_SAGEMAKER_BASE_WRITER"

    def __init__(self, client):
        super(AbstractSagemakerWriter, self).__init__(client)

    def build_request_payload(self, input_df):
        pass

    def can_write(self, input_df):
        from botocore.exceptions import ClientError  # in-function import: ugly workaround for Python 2 unit tests

        try:
            return self.write(input_df)
        except ClientError as e:
            if "Error" in e.response and "Message" in e.response["Error"]:
                message = e.response["Error"]["Message"].lower()
                if "type" in message and "not supported" in message:
                    return False
            raise e

    @abstractmethod
    def write(self, input_df):
        pass
