function fm_load_env_files(){
	# Load additional user-defined environment last if any
	if [ -f "$BINDIR"/env-site.sh ]; then
  		source "$BINDIR"/env-site.sh
	fi
}

function fm_get_cp() {
	# Load our log4j.properties first so that it does not get overriden by Hadoop,
	# and first the user's one
	_CP="$DIP_HOME/bin"
	_CP+=":$DKUINSTALLDIR/dist"
	# Load our code
	_CP+=":$DKUINSTALLDIR/dist/dataiku-core.jar"
	_CP+=":$DKUINSTALLDIR/dist/dataiku-app-platform.jar"
	_CP+=":$DKUINSTALLDIR/dist/dataiku-fm-common.jar"
	_CP+=":$DKUINSTALLDIR/dist/dataiku-fm-server.jar"
	# Load our dependencies
	_CP+=":$DKUINSTALLDIR/lib/ivy/fm-server-run/*"
	_CP+=":$DKUINSTALLDIR/lib/ivy/common-run/*"
	_CP+=":$DKUINSTALLDIR/lib/shadelib/*"
	_CP+=":$DKUINSTALLDIR/lib/third/*"

	echo "$_CP"
}

function fm_set_java_env(){
	# Java environment to use
	if [ -z "$DKUJAVABIN" ]; then
	  echo >&2 "FATAL: DKUJAVABIN is not defined. Please check $BINDIR/env-default.sh"
	  exit 1
	fi
	# JaCoCo executions
	if [ -n "$DKU_JACOCO_PATH" ]; then
		DKU_FM_JAVA_OPTS+=" -javaagent:$DKU_JACOCO_PATH=destfile=jacoco.fm.exec"
		DKU_FMCLI_JAVA_OPTS+=" -javaagent:$DKU_JACOCO_PATH=destfile=jacoco.cimcli.exec"
	fi
}

function fm_set_global_env(){
	# Force default locale
	export LC_ALL=en_US.UTF-8
	# Default to write-protect all created files
	umask 22
	# Raise default ulimits to more reasonable values
	case "$(uname)" in
		Linux)
			ulimit -Sn hard
			ulimit -Su hard
			;;
		Darwin)
			if [ "$(ulimit -Sn)" != "unlimited" -a "$(ulimit -Sn)" -lt 1024 ]; then
				# Attempt to push limit, ignore errors
				ulimit -Sn 1024 2>/dev/null || true
			fi
			;;
	esac
}

function fm_set_py_env(){
	# Python environment to use
	if [ -z "$DKUPYTHONBIN" ]; then
		export DKUPYTHONBIN="$DIP_HOME"/bin/python
	fi
}

function fm_env_sanity_check() {
	# Globally disable http proxy for localhost, as we use it for interprocess communication
	if [ -z "$DKU_NOPROXY_SET" -a \( -n "$http_proxy" -o -n "$HTTP_PROXY" \) ]; then
		if [ -n "$no_proxy" ]; then
			export no_proxy="127.0.0.1,localhost,$no_proxy"
		elif [ -n "$NO_PROXY" ]; then
			export NO_PROXY="127.0.0.1,localhost,$NO_PROXY"
		else
			export no_proxy="127.0.0.1,localhost"
		fi
		export DKU_NOPROXY_SET=1
	fi
}
