/*
 * Decompiled with CFR 0.152.
 */
package com.BoxOfC.LevenshteinAutomaton;

import com.BoxOfC.LevenshteinAutomaton.AugBitSet;
import com.BoxOfC.LevenshteinAutomaton.ParametricState;
import com.BoxOfC.LevenshteinAutomaton.Position;
import com.BoxOfC.LevenshteinAutomaton.State;
import com.BoxOfC.MDAG.MDAG;
import com.BoxOfC.MDAG.MDAGNode;
import com.BoxOfC.MDAG.SimpleMDAGNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;
import java.util.TreeSet;

public class LevenshteinAutomaton {
    private static final HashMap<Integer, HashMap<ParametricState, HashMap<AugBitSet, ParametricState>>> transitionHashMapContainerHashMap = new HashMap();
    private static final State initialState = new State(new Position[]{new Position(0, 0, false)});

    public static int computeEditDistance(String str1, String str2) {
        int i;
        int str1Length = str1.length();
        int str2Length = str2.length();
        if (str1.equals(str2)) {
            return 0;
        }
        if (str1Length == 0) {
            return str2.length();
        }
        if (str2Length == 0) {
            return str1.length();
        }
        int[] ancestorMatrixCol = new int[str2Length + 1];
        int[] previousMatrixCol = new int[str2Length + 1];
        int[] currentMatrixCol = new int[str2Length + 1];
        for (i = 0; i < previousMatrixCol.length; ++i) {
            previousMatrixCol[i] = i;
        }
        for (i = 0; i < str1Length; ++i) {
            int j;
            currentMatrixCol[0] = i + 1;
            for (j = 0; j < str2Length; ++j) {
                int deletionCost = currentMatrixCol[j] + 1;
                int insertionCost = previousMatrixCol[j + 1] + 1;
                int curCharEditDistance = str1.charAt(i) == str2.charAt(j) ? 0 : 1;
                int substitutionCost = previousMatrixCol[j] + curCharEditDistance;
                int minEditOperationCost = Math.min(deletionCost, insertionCost);
                minEditOperationCost = Math.min(minEditOperationCost, substitutionCost);
                if (i > 0 && j > 0 && str1.charAt(i) == str2.charAt(j - 1) && str1.charAt(i - 1) == str2.charAt(j)) {
                    minEditOperationCost = Math.min(minEditOperationCost, ancestorMatrixCol[j - 1] + curCharEditDistance);
                }
                currentMatrixCol[j + 1] = minEditOperationCost;
            }
            for (j = 0; j < previousMatrixCol.length; ++j) {
                ancestorMatrixCol[j] = previousMatrixCol[j];
                previousMatrixCol[j] = currentMatrixCol[j];
            }
        }
        return currentMatrixCol[str2Length];
    }

    public static boolean isWithinEditDistanceNonAutomaton(int maxEditDistance, String str1, String str2) {
        return LevenshteinAutomaton.computeEditDistance(str1, str2) <= maxEditDistance;
    }

    public static boolean isWithinEditDistance(int maxEditDistance, String str1, String str2) {
        State currentState = initialState;
        int automatonStringCharCount = str1.length();
        int dictionaryStringCharCount = str2.length();
        for (int i = 0; i < dictionaryStringCharCount; ++i) {
            if ((currentState = currentState.transition(maxEditDistance, str1, str2.charAt(i))) != null) continue;
            return false;
        }
        return LevenshteinAutomaton.isAcceptState(currentState, automatonStringCharCount, maxEditDistance);
    }

    private static void procureNewBasedStates(LinkedList<State> basedStateLinkedList, Position p, int maxEditDistance) {
        LinkedList<State> newBasedStateLinkedList = new LinkedList<State>();
        newBasedStateLinkedList.add(new State(new Position[]{p}));
        for (State currentState : basedStateLinkedList) {
            if (!State.canBeState(currentState, p, maxEditDistance)) continue;
            newBasedStateLinkedList.add(new State(currentState, p));
        }
        basedStateLinkedList.addAll(newBasedStateLinkedList);
    }

    private static LinkedList<State> procureBasedStates(Position basePosition, int maxRelevantSubwordSize, int maxEditDistance) {
        LinkedList<State> basedStateLinkedList = new LinkedList<State>();
        basedStateLinkedList.add(new State(new Position[]{basePosition}));
        for (int e = 1; e <= maxEditDistance; ++e) {
            for (int i = 0; i < maxRelevantSubwordSize; ++i) {
                Position currentPosition = new Position(i, e, false);
                if (basePosition.subsumes(currentPosition, maxEditDistance)) {
                    LevenshteinAutomaton.procureNewBasedStates(basedStateLinkedList, currentPosition, maxEditDistance);
                }
                if (i > maxRelevantSubwordSize - 2) continue;
                Position currentTPosition = new Position(i, e, true);
                if (!basePosition.subsumes(currentPosition, maxEditDistance)) continue;
                LevenshteinAutomaton.procureNewBasedStates(basedStateLinkedList, currentTPosition, maxEditDistance);
            }
        }
        return basedStateLinkedList;
    }

    private static HashSet<ParametricState> procureParametricStates(int maxRelevantSubwordSize, int maxEditDistance) {
        HashSet<ParametricState> parametricStateHashSet = new HashSet<ParametricState>();
        for (int i = 0; i < maxRelevantSubwordSize; ++i) {
            Position basePosition = new Position(i, 0, false);
            LinkedList<State> basedStateLinkedList = LevenshteinAutomaton.procureBasedStates(basePosition, maxRelevantSubwordSize, maxEditDistance);
            for (State currentNewState : basedStateLinkedList) {
                parametricStateHashSet.add(new ParametricState(currentNewState));
            }
        }
        return parametricStateHashSet;
    }

    private static ArrayList<AugBitSet> produceBinaryPermutations(int maxBitCount) {
        int i;
        int totalPermutationCount = 0;
        for (int i2 = 1; i2 < maxBitCount + 1; ++i2) {
            totalPermutationCount = (int)((double)totalPermutationCount + Math.pow(2.0, i2));
        }
        ArrayList<AugBitSet> binaryPermutationContainerArrayList = new ArrayList<AugBitSet>(totalPermutationCount + 1);
        for (i = 0; i <= 1; ++i) {
            binaryPermutationContainerArrayList.add(new AugBitSet(1));
            ((AugBitSet)binaryPermutationContainerArrayList.get(binaryPermutationContainerArrayList.size() - 1)).set(0, i != 0);
        }
        i = 0;
        while (((AugBitSet)binaryPermutationContainerArrayList.get(i)).getRelevantBitSetSize() < maxBitCount) {
            for (int j = 0; j <= 1; ++j) {
                AugBitSet currentPermutationBitSet = (AugBitSet)binaryPermutationContainerArrayList.get(i);
                AugBitSet newPermutationBitSet = new AugBitSet(currentPermutationBitSet.getRelevantBitSetSize() + 1);
                newPermutationBitSet.xor(currentPermutationBitSet);
                newPermutationBitSet.set(newPermutationBitSet.getRelevantBitSetSize() - 1, j != 0);
                binaryPermutationContainerArrayList.add(newPermutationBitSet);
            }
            ++i;
        }
        binaryPermutationContainerArrayList.add(new AugBitSet(0));
        return binaryPermutationContainerArrayList;
    }

    private static void createParametricStateTransitionMap(int maxEditDistance) {
        if (!transitionHashMapContainerHashMap.containsKey(maxEditDistance)) {
            HashMap transitionHashMap = new HashMap();
            int maxRelevantSubwordSize = 2 * maxEditDistance + 1;
            HashSet<ParametricState> parametricStateHashSet = LevenshteinAutomaton.procureParametricStates(maxRelevantSubwordSize, maxEditDistance);
            ArrayList<AugBitSet> characteristicVectorPermutationContainerArrayList = LevenshteinAutomaton.produceBinaryPermutations(maxRelevantSubwordSize);
            for (AugBitSet characteristicVector : characteristicVectorPermutationContainerArrayList) {
                for (ParametricState currentParametricState : parametricStateHashSet) {
                    if (currentParametricState.getLargestPositionOffset() > characteristicVector.getRelevantBitSetSize()) continue;
                    State currentConcreteState = currentParametricState.createActualState(0);
                    State transitionState = currentConcreteState.transition(maxEditDistance, characteristicVector);
                    ParametricState transitionParametricState = null;
                    if (transitionState != null) {
                        int minimumBoundariesDifference = State.getMinimumBoundariesDifference(currentConcreteState, transitionState);
                        transitionParametricState = new ParametricState(transitionState, minimumBoundariesDifference);
                    }
                    if (!transitionHashMap.containsKey(currentParametricState)) {
                        transitionHashMap.put(currentParametricState, new HashMap());
                    }
                    ((HashMap)transitionHashMap.get(currentParametricState)).put(characteristicVector, transitionParametricState);
                }
            }
            transitionHashMapContainerHashMap.put(maxEditDistance, transitionHashMap);
        }
    }

    private static Object[] createProcessingStepStackEntry(String transitionPathString, Object mdagTransitionPathEndNode, State lAutomatonTransitionPathEndState) {
        Object[] processingStepDataArray = new Object[]{transitionPathString, mdagTransitionPathEndNode, lAutomatonTransitionPathEndState};
        return processingStepDataArray;
    }

    private static Object[] createProcessingStepStackEntry(String transitionPathString, Object mdagTransitionPathEndNode, State lAutomatonTransitionPathEndState, ParametricState lAutomatonTransitionPathEndParametricState) {
        Object[] processingStepDataArray = new Object[]{transitionPathString, mdagTransitionPathEndNode, lAutomatonTransitionPathEndState, lAutomatonTransitionPathEndParametricState};
        return processingStepDataArray;
    }

    public static LinkedList<String> iterativeFuzzySearch(int maxEditDistance, String automatonString, MDAG mdag) {
        LinkedList<String> resultStringLinkedList = new LinkedList<String>();
        Stack<Object[]> processingStepStack = new Stack<Object[]>();
        boolean mdagIsSimplified = mdag.getSourceNode().getClass().equals(SimpleMDAGNode.class);
        SimpleMDAGNode[] simpleMDAGArray = mdag.getSimpleMDAGArray();
        processingStepStack.push(LevenshteinAutomaton.createProcessingStepStackEntry("", mdag.getSourceNode(), initialState));
        TreeSet charTreeSet = mdag.getTransitionLabelSet();
        int charCount = charTreeSet.size();
        int counter = 0;
        char[] charArray = new char[charCount];
        for (Character c : charTreeSet) {
            charArray[counter++] = c.charValue();
        }
        while (!processingStepStack.isEmpty()) {
            Object[] currentProcessingStepDataArray = (Object[])processingStepStack.pop();
            Object currentNodeObj = currentProcessingStepDataArray[1];
            State currentState = (State)currentProcessingStepDataArray[2];
            for (int i = 0; i < charCount; ++i) {
                State transitionState;
                MDAGNode transitionNode;
                char currentChar = charArray[i];
                Object object = transitionNode = mdagIsSimplified ? ((SimpleMDAGNode)currentNodeObj).transition(simpleMDAGArray, currentChar) : ((MDAGNode)currentNodeObj).transition(currentChar);
                if (transitionNode == null || (transitionState = currentState.transition(maxEditDistance, automatonString, currentChar)) == null) continue;
                String transitionPathString = (String)currentProcessingStepDataArray[0] + currentChar;
                processingStepStack.push(LevenshteinAutomaton.createProcessingStepStackEntry(transitionPathString, transitionNode, transitionState));
                if (!MDAG.isAcceptNode((Object)transitionNode) || !LevenshteinAutomaton.isAcceptState(transitionState, automatonString.length(), maxEditDistance)) continue;
                resultStringLinkedList.add(transitionPathString);
            }
        }
        return resultStringLinkedList;
    }

    public static LinkedList<String> tableFuzzySearch(int maxEditDistance, String automatonString, MDAG mdag) {
        LinkedList<String> resultStringLinkedList = new LinkedList<String>();
        LevenshteinAutomaton.createParametricStateTransitionMap(maxEditDistance);
        HashMap<ParametricState, HashMap<AugBitSet, ParametricState>> transitionHashMap = transitionHashMapContainerHashMap.get(maxEditDistance);
        Stack<Object[]> processingStepStack = new Stack<Object[]>();
        boolean mdagIsSimplified = mdag.getSourceNode().getClass().equals(SimpleMDAGNode.class);
        SimpleMDAGNode[] simpleMDAGArray = mdag.getSimpleMDAGArray();
        processingStepStack.push(LevenshteinAutomaton.createProcessingStepStackEntry("", mdag.getSourceNode(), initialState, new ParametricState(initialState)));
        TreeSet charTreeSet = mdag.getTransitionLabelSet();
        int charCount = charTreeSet.size();
        int counter = 0;
        char[] charArray = new char[charCount];
        for (Character c : charTreeSet) {
            charArray[counter++] = c.charValue();
        }
        while (!processingStepStack.isEmpty()) {
            Object[] currentProcessingStepDataArray = (Object[])processingStepStack.pop();
            Object currentNodeObj = currentProcessingStepDataArray[1];
            State currentState = (State)currentProcessingStepDataArray[2];
            ParametricState currentParametricState = (ParametricState)currentProcessingStepDataArray[3];
            for (int i = 0; i < charCount; ++i) {
                MDAGNode transitionNode;
                char currentChar = charArray[i];
                Object object = transitionNode = mdagIsSimplified ? ((SimpleMDAGNode)currentNodeObj).transition(simpleMDAGArray, currentChar) : ((MDAGNode)currentNodeObj).transition(currentChar);
                if (transitionNode == null) continue;
                AugBitSet rscv = currentState.getRelevantSubwordCharacteristicVector(maxEditDistance, automatonString, currentChar);
                ParametricState transitionParametricState = transitionHashMap.get(currentParametricState).get(rscv);
                if (transitionParametricState == null) continue;
                State transitionState = transitionParametricState.createActualState(currentState.getMinimalBoundary() + transitionParametricState.getTransitionBoundaryOffset());
                String transitionPathString = (String)currentProcessingStepDataArray[0] + currentChar;
                processingStepStack.push(LevenshteinAutomaton.createProcessingStepStackEntry(transitionPathString, transitionNode, transitionState, transitionParametricState));
                if (!MDAG.isAcceptNode((Object)transitionNode) || !LevenshteinAutomaton.isAcceptState(transitionState, automatonString.length(), maxEditDistance)) continue;
                resultStringLinkedList.add(transitionPathString);
            }
        }
        return resultStringLinkedList;
    }

    public static LinkedList<String> fuzzySearchNonAutomaton(int maxEditDistance, String pertinentStr, Collection<String> strCollection) {
        LinkedList<String> resultStringLinkedList = new LinkedList<String>();
        for (String currentString : strCollection) {
            if (LevenshteinAutomaton.computeEditDistance(pertinentStr, currentString) > maxEditDistance) continue;
            resultStringLinkedList.add(currentString);
        }
        return resultStringLinkedList;
    }

    private static boolean isAcceptingPosition(Position p, int automatonStringLength, int automatonMaxEditDistance) {
        return automatonStringLength - p.getI() <= automatonMaxEditDistance - p.getE();
    }

    public static boolean isAcceptState(State s, int automatonStringLength, int automatonMaxEditDistance) {
        for (Position p : s.getMemberPositions()) {
            if (!LevenshteinAutomaton.isAcceptingPosition(p, automatonStringLength, automatonMaxEditDistance)) continue;
            return true;
        }
        return false;
    }

    public static void printTransitionMap(int maxEditDistance) {
        HashMap<ParametricState, HashMap<AugBitSet, ParametricState>> transitionHashMap = transitionHashMapContainerHashMap.get(maxEditDistance);
        if (transitionHashMap != null) {
            System.out.println("# of parametric states : " + transitionHashMap.size());
            for (Map.Entry<ParametricState, HashMap<AugBitSet, ParametricState>> transitionColumn : transitionHashMap.entrySet()) {
                System.out.println(transitionColumn.getKey() + "\n");
                for (Map.Entry<AugBitSet, ParametricState> transitionEntry : transitionColumn.getValue().entrySet()) {
                    System.out.println(transitionEntry.getKey().toString() + "\t" + transitionEntry.getValue());
                }
            }
        }
    }
}

