/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.auth;

import com.dataiku.common.audit.AuthError;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.NotAuthenticatedException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.security.auth.APIAuthUtils;
import com.google.gson.JsonObject;
import jakarta.servlet.http.HttpServletRequest;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.binary.Base64;

public class APIAuthUtilsBase {
    public static final String BEARER_PREFIX = "Bearer ";
    public static final String BASIC_PREFIX = "Basic ";

    public static String getKeyStr(JsonObject parsedHeaders) throws DKUSecurityException {
        String authorizationHeader = parsedHeaders.has("authorization") ? parsedHeaders.get("authorization").getAsString() : null;
        return APIAuthUtilsBase.getKeyStrInternal(authorizationHeader);
    }

    protected static String getKeyStrInternal(String authorizationHeader) throws DKUSecurityException {
        block7: {
            if (authorizationHeader != null) {
                if (authorizationHeader.startsWith(BASIC_PREFIX)) {
                    String b64 = authorizationHeader.substring(BASIC_PREFIX.length()).trim();
                    try {
                        String credentials = new String(Base64.decodeBase64((String)b64), StandardCharsets.UTF_8);
                        int separatorIndex = credentials.indexOf(":");
                        if (separatorIndex > 0) {
                            return credentials.substring(0, separatorIndex);
                        }
                        if (separatorIndex == 0 && credentials.length() > 1) {
                            return credentials.substring(1);
                        }
                        break block7;
                    }
                    catch (Exception e) {
                        throw new DKUSecurityException("Malformed API Key");
                    }
                }
                if (authorizationHeader.startsWith(BEARER_PREFIX)) {
                    return authorizationHeader.substring(BEARER_PREFIX.length()).trim();
                }
            }
        }
        throw new NotAuthenticatedException("API Key not provided (" + APIAuthUtilsBase.getObfuscatedAuthorizationHeader(authorizationHeader) + ")", "no-api-key");
    }

    private static String getObfuscatedAuthorizationHeader(String authorizationHeader) {
        String secret;
        if (authorizationHeader == null) {
            return "";
        }
        int schemeEndIndex = authorizationHeader.indexOf(" ");
        String scheme = schemeEndIndex == -1 ? "" : authorizationHeader.substring(0, schemeEndIndex + 1);
        String string = secret = schemeEndIndex == -1 ? authorizationHeader : authorizationHeader.substring(schemeEndIndex + 1);
        if (secret.length() < 10) {
            return scheme + "*".repeat(secret.length());
        }
        return scheme + secret.substring(0, 2) + "*".repeat(secret.length() - 4) + secret.substring(secret.length() - 2);
    }

    public static BasicCredential decodeBasicAuthentication(String authorizationHeader) {
        if (authorizationHeader == null) {
            throw new IllegalArgumentException("No Authorization header");
        }
        if (authorizationHeader.startsWith(BASIC_PREFIX)) {
            String b64 = authorizationHeader.substring(BASIC_PREFIX.length()).trim();
            try {
                String credentials = new String(Base64.decodeBase64((String)b64), StandardCharsets.UTF_8);
                if (credentials.contains(":")) {
                    return new BasicCredential(credentials.split(":", 2)[0], credentials.split(":", 2)[1]);
                }
                throw new IllegalArgumentException("Malformed Authorization header (no :)");
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Malformed Authorization header");
            }
        }
        throw new IllegalArgumentException("Bad Authorization header");
    }

    public static String extractApiKey(HttpServletRequest request) throws NotAuthenticatedException, UnauthorizedException {
        try {
            return APIAuthUtils.getKeyStr(request);
        }
        catch (NotAuthenticatedException e) {
            throw e;
        }
        catch (DKUSecurityException e) {
            throw new UnauthorizedException(e.getMessage(), AuthError.API_KEY_MALFORMED.name(), e);
        }
    }

    public static class BasicCredential {
        public final String user;
        public final String password;

        public BasicCredential(String user, String password) {
            this.user = user;
            this.password = password;
        }
    }
}

