/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api;

import com.dataiku.common.server.APIError;
import com.dataiku.common.server.DKUControllerBase;
import com.dataiku.dip.ApplicativeException;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.APIIllegalArgumentException;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.NotAuthenticatedException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.reports.IReflectedEventsService;
import com.dataiku.dip.security.auth.UserAuthenticationException;
import com.dataiku.dip.server.api.PublicAPICodes;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.intellij.lang.annotations.PrintFormat;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.servlet.ModelAndView;

public class PublicAPIControllerBase
extends DKUControllerBase {
    @Autowired
    protected IReflectedEventsService reflectedEventsService;
    static final String dssVersion = DKUApp.getDSSVersion().product_version;
    public static final DKULogger logger = DKULogger.getLogger((String)"dip.publicapi");

    @ModelAttribute
    public static void setHeader(HttpServletResponse resp) {
        resp.setHeader("DSS-Version", dssVersion);
        resp.setHeader("DSS-API-Version", "1");
    }

    public void writeMessage(HttpServletResponse resp, @PrintFormat String format, Object ... args) throws IOException {
        PublicAPIControllerBase.setHeader(resp);
        ResponseMessage rs = new ResponseMessage(String.format(format, args));
        DIPInternalControllerBase.writeJSON(resp, rs);
    }

    public static void writeJSON(HttpServletResponse resp, Object data) throws IOException {
        PublicAPIControllerBase.setHeader(resp);
        if (data == null) {
            resp.setStatus(204);
        } else {
            if (data instanceof String) {
                data = new ResponseMessage((String)data);
            }
            DIPInternalControllerBase.writeJSON(resp, data);
        }
    }

    @Override
    protected void writeFile(HttpServletResponse resp, File file, String contentType) throws IOException {
        PublicAPIControllerBase.setHeader(resp);
        resp.setContentType(contentType);
        try (FileInputStream fis = new FileInputStream(file);){
            IOUtils.copy((InputStream)fis, (OutputStream)resp.getOutputStream());
        }
    }

    protected void writeFileWithAutoDecompress(HttpServletResponse resp, File file, String contentType) throws IOException {
        PublicAPIControllerBase.setHeader(resp);
        resp.setContentType(contentType);
        try (InputStream is = DKUFileUtils.readWithAutoDecompress((File)file);){
            IOUtils.copyLarge((InputStream)is, (OutputStream)resp.getOutputStream());
        }
    }

    @Override
    protected void writeStream(HttpServletResponse resp, InputStream is, String mimeType, String filename) throws IOException {
        PublicAPIControllerBase.setHeader(resp);
        super.writeStream(resp, is, mimeType, filename);
    }

    protected void require(boolean test, String msg) {
        if (!test) {
            throw new DKUControllerBase.MalformedRequestException(msg);
        }
    }

    protected byte[] getRequestBodyData(HttpServletRequest req) throws IOException {
        return IOUtils.toByteArray((InputStream)req.getInputStream());
    }

    @Deprecated
    protected Map<String, String> getRequestBody(HttpServletRequest req) throws IOException {
        StringBuilder sb = new StringBuilder();
        String line = null;
        BufferedReader reader = req.getReader();
        while ((line = reader.readLine()) != null) {
            sb.append(line);
        }
        String body = sb.toString();
        return (Map)JSON.parse((String)body, (TypeToken)new TypeToken<HashMap<String, String>>(){});
    }

    @Deprecated
    protected String getMandatory(Map<String, String> params, String name) throws MissingServletRequestParameterException {
        String param = params.get(name);
        if (StringUtils.isBlank((String)param)) {
            throw new MissingServletRequestParameterException(param, "String");
        }
        return param;
    }

    @Deprecated
    protected String getParam(Map<String, String> params, String name, String defaultValue) throws MissingServletRequestParameterException {
        String param = params.get(name);
        if (StringUtils.isBlank((String)param)) {
            return defaultValue;
        }
        return param;
    }

    @Deprecated
    protected <T> T getMandatoryAs(Map<String, String> params, String name, Class<T> clazz) throws MissingServletRequestParameterException {
        Object ret;
        String param = params.get(name);
        if (StringUtils.isBlank((String)param)) {
            throw new MissingServletRequestParameterException(param, "String");
        }
        try {
            ret = JSON.parse((String)param, clazz);
        }
        catch (Exception e) {
            throw new DKUControllerBase.MalformedRequestException("Invalid '" + name + "' parameter: " + e.getMessage(), e);
        }
        return (T)ret;
    }

    @ExceptionHandler(value={Throwable.class})
    public ModelAndView resolveException(HttpServletRequest req, HttpServletResponse resp, Throwable e) {
        if (PublicAPIControllerBase.exceptionStackIsWorthPrintingInLogs(e)) {
            logger.error((Object)("API call '" + req.getRequestURI() + "' failed"), e);
        } else {
            logger.error((Object)("API call '" + req.getRequestURI() + "' failed: " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
        try {
            this.sendError(e, req, resp);
        }
        catch (Exception e2) {
            logger.error((Object)"Additional exception while sending error", (Throwable)e2);
        }
        return null;
    }

    private void sendError(Throwable e, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (resp.isCommitted()) {
            logger.error((Object)"Response already committed, cannot send error", e);
            resp.sendError(-1);
            return;
        }
        PublicAPIControllerBase.resetResponseButKeepHeaders(resp);
        if (e instanceof NotAuthenticatedException || e instanceof UserAuthenticationException) {
            if (req.getHeader("authorization") != null && req.getHeader("authorization").startsWith("Bearer ")) {
                resp.addHeader("WWW-Authenticate", "Bearer realm=\"DSS API\"");
            } else {
                resp.addHeader("WWW-Authenticate", "Basic realm=\"DSS API\"");
            }
            PublicAPIControllerBase.sendErrorFromThrowableNoStack(e, 401, resp);
        } else if (e instanceof SecurityException || e instanceof UnauthorizedException) {
            PublicAPIControllerBase.sendErrorFromThrowableNoStack(e, 403, resp);
        } else if (e instanceof DKUControllerBase.MalformedRequestException) {
            PublicAPIControllerBase.sendErrorFromThrowableNoStack(e, 400, resp);
        } else if (e instanceof MissingServletRequestParameterException) {
            PublicAPIControllerBase.sendErrorFromThrowableNoStack(e, 400, resp);
        } else if (e instanceof HttpRequestMethodNotSupportedException) {
            PublicAPIControllerBase.sendErrorFromThrowableNoStack(e, 405, resp);
        } else if (e instanceof IllegalArgumentException) {
            PublicAPIControllerBase.sendErrorFromThrowableWithStack(e, 400, resp);
        } else if (e instanceof NotFoundException) {
            PublicAPIControllerBase.sendErrorFromThrowableWithStack(e, 404, resp);
        } else if (e instanceof APIError.APIErrorException) {
            resp.setStatus(500);
            resp.setContentType("application/json");
            resp.getWriter().write(new Gson().toJson((Object)((APIError.APIErrorException)e).error));
        } else if (e instanceof ApplicativeException) {
            resp.setStatus(400);
            resp.setContentType("application/json");
            APIError ae = new APIError("ApplicativeException", e.getMessage());
            ae.title = ((ApplicativeException)e).getTitle();
            ae.code = ((ApplicativeException)e).code;
            ae.payload = ((ApplicativeException)e).payload;
            resp.getWriter().write(JSON.json((Object)ae));
        } else {
            PublicAPIControllerBase.sendErrorFromThrowableWithStack(e, 500, resp);
        }
        if (!(e instanceof DKUSecurityException || e instanceof SecurityException || e instanceof DKUControllerBase.MalformedRequestException || e instanceof MissingServletRequestParameterException || e instanceof HttpRequestMethodNotSupportedException || e instanceof NotFoundException || e instanceof CodedException && "ERR_CONNECTION_OAUTH2_REFRESH_TOKEN_FLOW_FAIL".equals(((CodedException)e).code.getCode()))) {
            IReflectedEventsService.ReflectedEvent re = new IReflectedEventsService.ReflectedEvent("Public API call failure: " + req.getRequestURI(), e);
            this.reflectedEventsService.publish(re);
        }
    }

    protected void checkArgument(boolean expression, InfoMessage.MessageCode code, @PrintFormat String message, Object ... arguments) {
        if (!expression) {
            throw new APIIllegalArgumentException(code, String.format(message, arguments));
        }
    }

    protected void checkNotNull(Object o, @PrintFormat String message, Object ... arguments) {
        this.checkArgument(o != null, PublicAPICodes.ERR_PUBLICAPI_EMPTY_PARAMETER, message, arguments);
    }

    protected void checkNotEmpty(String str, @PrintFormat String message, Object ... arguments) {
        this.checkArgument(StringUtils.isNotEmpty((String)str), PublicAPICodes.ERR_PUBLICAPI_EMPTY_PARAMETER, message, arguments);
    }

    protected void checkNotBlank(String str, @PrintFormat String message, Object ... arguments) {
        this.checkArgument(StringUtils.isNotBlank((String)str), PublicAPICodes.ERR_PUBLICAPI_EMPTY_PARAMETER, message, arguments);
    }

    protected final <E extends Enum<E>> E parseEnumFromString(String stringRequestParam, Class<E> enumClass) {
        return this.parseEnumFromString(stringRequestParam, enumClass, EnumSet.allOf(enumClass));
    }

    @SafeVarargs
    protected final <E extends Enum<E>> E parseEnumFromString(String stringRequestParam, Class<E> enumClass, E ... allowedEnums) {
        return this.parseEnumFromString(stringRequestParam, enumClass, Set.of(allowedEnums));
    }

    protected <E extends Enum<E>> E parseEnumFromString(String stringRequestParam, Class<E> enumClass, Set<E> allowedEnums) {
        try {
            E value = Enum.valueOf(enumClass, stringRequestParam);
            if (allowedEnums.contains(value)) {
                return value;
            }
            throw new IllegalArgumentException(String.format("Bad parameter '%s', expected one of '%s'", stringRequestParam, allowedEnums));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Bad parameter '%s', expected one of '%s'", stringRequestParam, allowedEnums));
        }
    }

    public static class ResponseMessage {
        String msg;

        public ResponseMessage(String msg) {
            this.msg = msg;
        }
    }

    public static class ResponseMessageWithId
    extends ResponseMessage {
        public String id;

        public ResponseMessageWithId(String id, String msg) {
            super(msg);
            this.id = id;
        }
    }
}

