/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.internal.SdkInternalList;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.DescribeFleetInstancesRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.Filter;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;

public class DescribeFleetInstancesRequestMarshaller
implements Marshaller<Request<DescribeFleetInstancesRequest>, DescribeFleetInstancesRequest> {
    @Override
    public Request<DescribeFleetInstancesRequest> marshall(DescribeFleetInstancesRequest describeFleetInstancesRequest) {
        SdkInternalList describeFleetInstancesRequestFiltersList;
        if (describeFleetInstancesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeFleetInstancesRequest> request = new DefaultRequest<DescribeFleetInstancesRequest>(describeFleetInstancesRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeFleetInstances");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeFleetInstancesRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger(describeFleetInstancesRequest.getMaxResults()));
        }
        if (describeFleetInstancesRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeFleetInstancesRequest.getNextToken()));
        }
        if (describeFleetInstancesRequest.getFleetId() != null) {
            request.addParameter("FleetId", StringUtils.fromString(describeFleetInstancesRequest.getFleetId()));
        }
        if (!(describeFleetInstancesRequestFiltersList = (SdkInternalList)describeFleetInstancesRequest.getFilters()).isEmpty() || !describeFleetInstancesRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeFleetInstancesRequestFiltersListValue : describeFleetInstancesRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeFleetInstancesRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString(describeFleetInstancesRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describeFleetInstancesRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString(filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        return request;
    }
}

