/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.elasticloadbalancingv2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.elasticloadbalancingv2.model.AddListenerCertificatesRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.elasticloadbalancingv2.model.Certificate;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;
import java.util.List;

public class AddListenerCertificatesRequestMarshaller
implements Marshaller<Request<AddListenerCertificatesRequest>, AddListenerCertificatesRequest> {
    @Override
    public Request<AddListenerCertificatesRequest> marshall(AddListenerCertificatesRequest addListenerCertificatesRequest) {
        if (addListenerCertificatesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<AddListenerCertificatesRequest> request = new DefaultRequest<AddListenerCertificatesRequest>(addListenerCertificatesRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "AddListenerCertificates");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (addListenerCertificatesRequest.getListenerArn() != null) {
            request.addParameter("ListenerArn", StringUtils.fromString(addListenerCertificatesRequest.getListenerArn()));
        }
        if (addListenerCertificatesRequest.getCertificates() != null) {
            List<Certificate> certificatesList = addListenerCertificatesRequest.getCertificates();
            if (certificatesList.isEmpty()) {
                request.addParameter("Certificates", "");
            } else {
                int certificatesListIndex = 1;
                for (Certificate certificatesListValue : certificatesList) {
                    if (certificatesListValue != null) {
                        if (certificatesListValue.getCertificateArn() != null) {
                            request.addParameter("Certificates.member." + certificatesListIndex + ".CertificateArn", StringUtils.fromString(certificatesListValue.getCertificateArn()));
                        }
                        if (certificatesListValue.getIsDefault() != null) {
                            request.addParameter("Certificates.member." + certificatesListIndex + ".IsDefault", StringUtils.fromBoolean(certificatesListValue.getIsDefault()));
                        }
                    }
                    ++certificatesListIndex;
                }
            }
        }
        return request;
    }
}

