/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.cli;

import com.dataiku.dip.server.SpringUtils;
import com.dataiku.fm.cli.FMInternalCLI;
import com.dataiku.fm.model.settings.FMSettings;
import com.dataiku.fm.model.settings.FMTenancy;
import com.dataiku.fm.server.FMApp;
import com.dataiku.fm.server.FMSpring;
import com.google.common.base.Joiner;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public abstract class FMInternalCLICommand {
    protected FMSettings fmSettings;

    public int usage(int retcode, String msg) {
        if (msg != null) {
            System.err.println(msg);
        }
        new HelpFormatter().printHelp(this.usageString() + "\n" + this.description(), this.opts());
        return retcode;
    }

    public abstract String getUsageCommandName();

    public abstract String description();

    public String[] getUsageCommandArgs() {
        return new String[0];
    }

    protected void addCommandOptions(Options options) {
    }

    public int execute(String[] args) throws Exception {
        CommandLine commandLine = this.parseAndMiniSetup(args);
        FMSpring.doCLISetup();
        this.fmSettings = FMApp.getFMSettingsUnsafe();
        SpringUtils.getInstance().autowire((Object)this);
        return this.executeCommand(commandLine);
    }

    public abstract int executeCommand(CommandLine var1) throws Exception;

    protected String usageString() {
        FMTenancy tenancy = this.fmSettings.tenancy;
        ArrayList<String> terms = new ArrayList<String>();
        terms.add(this.getUsageCommandName());
        for (String arg : this.getUsageCommandArgs()) {
            if (arg.equals("TENANT_ID")) {
                if (tenancy != FMTenancy.MULTITENANT) continue;
                terms.add(arg);
                continue;
            }
            terms.add(arg);
        }
        return Joiner.on((String)" ").join(terms);
    }

    protected CommandLine parseAndMiniSetup(String[] args) throws ParseException, IOException {
        CommandLine cmdLine = new DefaultParser().parse(this.opts(), args);
        if (cmdLine.hasOption('v')) {
            Logger.getRootLogger().setLevel(Level.DEBUG);
        }
        FMApp.autoconfigure();
        Logger.getLogger((String)"org.springframework.beans").setLevel(Level.INFO);
        if (cmdLine.hasOption('h')) {
            this.usage(0, null);
            throw new FMInternalCLI.EndOfCommandException();
        }
        assert (cmdLine.getArgs().length >= 1);
        return cmdLine;
    }

    protected Map<String, String> parseCmdArgs(CommandLine commandLine, String ... argNames) {
        ArrayList args = new ArrayList(commandLine.getArgList());
        args.remove(0);
        FMTenancy tenancy = this.fmSettings.tenancy;
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (String argName : argNames) {
            boolean optionalArgument;
            if (argName.equals("TENANT_ID") && tenancy == FMTenancy.MONOTENANT) {
                result.put(argName, "main");
                continue;
            }
            boolean bl = optionalArgument = argName.startsWith("[") && argName.endsWith("]");
            if (!optionalArgument && args.isEmpty()) {
                throw new IllegalArgumentException("Missing " + argName + " parameter.\nUsage: " + this.usageString());
            }
            if (optionalArgument && args.isEmpty()) continue;
            String actualArgName = optionalArgument ? argName.substring(1, argName.length() - 1) : argName;
            result.put(actualArgName, (String)args.remove(0));
        }
        if (!args.isEmpty()) {
            throw new IllegalStateException("Too many parameters supplied: " + Joiner.on((String)" ").join(args) + "\nUsage: " + this.usageString());
        }
        return result;
    }

    private Options opts() {
        Options opts = new Options();
        FMInternalCLI.addGlobalOptions(opts);
        this.addCommandOptions(opts);
        return opts;
    }
}

