/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.cloud;

import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.StringUtils;
import com.dataiku.fm.cloud.CloudCryptoServiceInterface;
import com.dataiku.fm.cloud.aws.AWSCloudCryptoService;
import com.dataiku.fm.cloud.azure.AzureCloudCryptoService;
import com.dataiku.fm.cloud.gcp.GCPCloudCryptoService;
import com.dataiku.fm.model.db.Tenant;
import com.dataiku.fm.model.settings.FMSettings;
import com.dataiku.fm.server.FMApp;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;

public class CloudCryptoService
implements CloudCryptoServiceInterface {
    private CloudCryptoServiceInterface adapter;

    @PostConstruct
    public void init() {
        FMSettings settings = FMApp.getFMSettingsUnsafe();
        switch (settings.cloud) {
            case AWS: {
                this.adapter = new AWSCloudCryptoService();
                break;
            }
            case AZURE: {
                this.adapter = new AzureCloudCryptoService();
                break;
            }
            case GCP: {
                this.adapter = new GCPCloudCryptoService();
            }
        }
        SpringUtils.getInstance().autowire((Object)this.adapter);
    }

    @Override
    public boolean isAbleToEncryptUsingTenantMasterKey() {
        return this.adapter.isAbleToEncryptUsingTenantMasterKey();
    }

    @Override
    public void checkEncryptionUsingTenantMasterKey() {
        this.adapter.checkEncryptionUsingTenantMasterKey();
    }

    @Override
    public boolean isAbleToEncrypt(Tenant tenant) {
        return this.adapter.isAbleToEncrypt(tenant);
    }

    @Override
    public void checkEncryption(Tenant tenant) {
        this.adapter.checkEncryption(tenant);
    }

    @Override
    public String encrypt(Tenant tenant, @Nonnull String cleartext) {
        return this.adapter.encrypt(tenant, cleartext);
    }

    @Override
    public String decrypt(Tenant tenant, String ciphertext) {
        if (StringUtils.nullIfBlank((String)ciphertext) == null) {
            return null;
        }
        if (this.isAbleToEncrypt(tenant)) {
            return this.adapter.decrypt(tenant, ciphertext);
        }
        return ciphertext;
    }
}

