/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.cloud.azure;

import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.utils.StringUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.credential.TokenCredential;
import com.dataiku.dss.shadelibazure.com.azure.core.credential.TokenRequestContext;
import com.dataiku.dss.shadelibazure.com.azure.core.http.ProxyOptions;
import com.dataiku.dss.shadelibazure.com.azure.core.http.okhttp.OkHttpAsyncHttpClientBuilder;
import com.dataiku.dss.shadelibazure.com.azure.core.management.profile.AzureProfile;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.AzureResourceManager;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.cryptography.CryptographyClient;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.cryptography.CryptographyClientBuilder;
import com.dataiku.fm.cloud.CloudCryptoService;
import com.dataiku.fm.cloud.azure.AzureUtils;
import com.dataiku.fm.model.db.CloudAccount;
import com.dataiku.fm.server.FMApp;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;

public class AzureClientService {
    @Autowired
    private CloudCryptoService cryptoService;
    private final Cache<String, AzureResourceManager> azureResourceManagerCache = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.MINUTES).build();
    private final Cache<String, CryptographyClient> cryptographyClientCache = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.MINUTES).build();
    private static final String TOKEN_RESOURCE = "https://management.azure.com/.default";

    private TokenCredential getTokenCredentials(CloudAccount cloudAccount) {
        switch (cloudAccount.getAzureAuthenticationMode()) {
            case MANAGED_IDENTITY: {
                return AzureUtils.getManagedIdentityCredentials(cloudAccount.getAzureManagedIdentityId());
            }
            case OAUTH2_AUTHENTICATION_METHOD_CLIENT_SECRET: {
                String decryptedSecret = cloudAccount.isEncrypted() ? this.cryptoService.decrypt(cloudAccount.getTenant(), cloudAccount.getAzureSecret()) : cloudAccount.getAzureSecret();
                return AzureUtils.getSecretCredentials(cloudAccount.getAzureClientId(), cloudAccount.getAzureTenantId(), decryptedSecret);
            }
            case OAUTH2_AUTHENTICATION_METHOD_CERTIFICATE: {
                String decryptedCertificatePwd = cloudAccount.isEncrypted() ? this.cryptoService.decrypt(cloudAccount.getTenant(), cloudAccount.getAzureCertificatePassword()) : cloudAccount.getAzureCertificatePassword();
                return AzureUtils.getCertificateCredentials(cloudAccount.getAzureClientId(), cloudAccount.getAzureTenantId(), cloudAccount.getAzureCertificatePath(), decryptedCertificatePwd);
            }
        }
        if (StringUtils.nullIfBlank((String)cloudAccount.getAzureManagedIdentityId()) == null) {
            return AzureUtils.getDefaultManagedIdentityCredentials();
        }
        return AzureUtils.getManagedIdentityCredentials(cloudAccount.getAzureManagedIdentityId());
    }

    public AzureResourceManager getAzureClient(CloudAccount cloudAccount) {
        return this.getAzureClient(cloudAccount, cloudAccount.getAzureSubscription());
    }

    public AzureResourceManager getAzureClient(CloudAccount cloudAccount, String subscription) {
        String cacheKey = cloudAccount.getCacheKeyOfAzureFields() + subscription;
        AzureResourceManager cachedAzureResourceManager = (AzureResourceManager)this.azureResourceManagerCache.getIfPresent((Object)cacheKey);
        if (cachedAzureResourceManager != null) {
            return cachedAzureResourceManager;
        }
        AzureResourceManager azureResourceManager = ((AzureResourceManager.Configurable)AzureResourceManager.configure().withHttpClient(new OkHttpAsyncHttpClientBuilder().proxy(AzureClientService.getProxyOptions()).build())).authenticate(this.getTokenCredentials(cloudAccount), new AzureProfile(AzureUtils.getAzureEnvironment())).withSubscription(subscription);
        this.azureResourceManagerCache.put((Object)cacheKey, (Object)azureResourceManager);
        return azureResourceManager;
    }

    public CryptographyClient getAzureCryptographyClient(CloudAccount cloudAccount, String keyId) {
        String cacheKey = cloudAccount.getCacheKeyOfAzureFields() + keyId;
        CryptographyClient cachedCryptographyClient = (CryptographyClient)this.cryptographyClientCache.getIfPresent((Object)cacheKey);
        if (cachedCryptographyClient != null) {
            return cachedCryptographyClient;
        }
        CryptographyClient cryptographyClient = new CryptographyClientBuilder().httpClient(new OkHttpAsyncHttpClientBuilder().proxy(AzureClientService.getProxyOptions()).build()).credential(this.getTokenCredentials(cloudAccount)).keyIdentifier(keyId).buildClient();
        this.cryptographyClientCache.put((Object)cacheKey, (Object)cryptographyClient);
        return cryptographyClient;
    }

    public void testGeneratingAnAccessToken(CloudAccount cloudAccount) {
        try {
            this.getTokenCredentials(cloudAccount).getTokenSync(new TokenRequestContext().addScopes(new String[]{TOKEN_RESOURCE}));
        }
        catch (Throwable e) {
            throw new IllegalStateException("Could not authenticate using the provided method and settings", e);
        }
    }

    private static ProxyOptions getProxyOptions() {
        ProxySettings proxySettings;
        if (FMApp.isCloudProxyEnabled() && (proxySettings = FMApp.getFMSettingsUnsafe().proxySettings).hasProxy()) {
            ProxyOptions proxyOptions = new ProxyOptions(proxySettings.isHTTP() ? ProxyOptions.Type.HTTP : ProxyOptions.Type.SOCKS5, new InetSocketAddress(proxySettings.host, proxySettings.port));
            if (proxySettings.hasAuthentication()) {
                proxyOptions.setCredentials(proxySettings.username, proxySettings.password);
            }
            return proxyOptions;
        }
        return null;
    }
}

