/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.cloud.azure;

import com.dataiku.dip.ApplicativeException;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.dns.models.ARecordSet;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.dns.models.DnsRecordSet;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.dns.models.DnsZone;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.dns.models.ZoneType;
import com.dataiku.fm.cloud.DNSservice;
import com.dataiku.fm.cloud.azure.AzureClientService;
import com.dataiku.fm.model.db.CloudAccount;
import com.dataiku.fm.model.db.PhysicalDNSRecord;
import com.dataiku.fm.model.db.VirtualNetwork;
import com.dataiku.fm.model.settings.FMSettings;
import com.dataiku.fm.server.FMApp;
import com.dataiku.fm.utils.DnsUtils;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AzureDNSService
implements DNSservice {
    @Autowired
    private AzureClientService clientService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.fm.cloud.azure.dns");

    @Override
    public Map<DNSservice.ZoneType, PhysicalDNSRecord> addDNSRecords(VirtualNetwork virtualNetwork, String recordName, String targetPublicIP, String targetPrivateIp, DNSservice.RecordType recordType, Map<String, String> tags) {
        HashMap<DNSservice.ZoneType, PhysicalDNSRecord> result = new HashMap<DNSservice.ZoneType, PhysicalDNSRecord>();
        DnsZone dnsZone = this.getDNSZone(virtualNetwork);
        logger.info((Object)("DNS strategy: " + String.valueOf(virtualNetwork)));
        switch (virtualNetwork.getDnsStrategy()) {
            case NONE: {
                break;
            }
            case VN_SPECIFIC_CLOUD_DNS_SERVICE: {
                String zoneId = virtualNetwork.getAzureDnsZoneId();
                String sanitizedDnsPrefix = DnsUtils.safeDnsPrefix(recordName, dnsZone.name());
                if (dnsZone.accessType() == ZoneType.PRIVATE) {
                    if (targetPrivateIp == null) break;
                    this.addDNSRecord(dnsZone, sanitizedDnsPrefix, targetPrivateIp, tags);
                    result.put(DNSservice.ZoneType.PRIVATE, new PhysicalDNSRecord(recordName, recordName, zoneId, DNSservice.RecordType.A, DNSservice.ZoneType.PRIVATE));
                    break;
                }
                if (targetPublicIP == null) break;
                this.addDNSRecord(dnsZone, sanitizedDnsPrefix, targetPublicIP, tags);
                result.put(DNSservice.ZoneType.PUBLIC, new PhysicalDNSRecord(recordName, recordName, zoneId, DNSservice.RecordType.A, DNSservice.ZoneType.PUBLIC));
                break;
            }
            case FM_MANAGED_CLOUD_DNS_SERVICE: {
                FMSettings settings = FMApp.getFMSettingsUnsafe();
                String zoneId = settings.azureSettings.dnsZoneId;
                String subzone = virtualNetwork.getTenant().getId().replaceAll("-", "").toLowerCase(Locale.ENGLISH);
                this.addDNSRecord(dnsZone, DnsUtils.relativeSafeDnsName(recordName, subzone), targetPublicIP, tags);
                result.put(DNSservice.ZoneType.PUBLIC, new PhysicalDNSRecord(recordName, recordName, zoneId, DNSservice.RecordType.A, DNSservice.ZoneType.PUBLIC));
                break;
            }
        }
        return result;
    }

    @Override
    public void removeDNSRecords(VirtualNetwork virtualNetwork, String recordName, DNSservice.RecordType recordType, boolean computeDNSNameWithZone) {
        this.removeAzureDNSRecord(virtualNetwork, recordName);
    }

    @Override
    public Map<DNSservice.ZoneType, String> getFQDNs(VirtualNetwork virtualNetwork, String recordName) {
        logger.info((Object)("DNS strategy: " + String.valueOf((Object)virtualNetwork.getDnsStrategy())));
        HashMap<DNSservice.ZoneType, String> hostnames = new HashMap<DNSservice.ZoneType, String>();
        switch (virtualNetwork.getDnsStrategy()) {
            case NONE: {
                break;
            }
            case VN_SPECIFIC_CLOUD_DNS_SERVICE: {
                CloudAccount cloudAccount = virtualNetwork.getCloudAccountOrVirtualCloudAccount();
                DnsZone dnsZone = (DnsZone)this.clientService.getAzureClient(cloudAccount).dnsZones().getById(virtualNetwork.getAzureDnsZoneId());
                if (dnsZone == null) break;
                hostnames.put(this.toRecordType(dnsZone.accessType()), DnsUtils.relativeSafeDnsName(recordName, dnsZone.name()));
                break;
            }
            case FM_MANAGED_CLOUD_DNS_SERVICE: {
                DnsZone dnsZone = (DnsZone)this.clientService.getAzureClient(virtualNetwork.getTenant().getVirtualCloudAccount(FMApp.getFMSettingsUnsafe())).dnsZones().getById(FMApp.getFMSettingsUnsafe().azureSettings.dnsZoneId);
                if (dnsZone == null) break;
                String subzone = virtualNetwork.getTenant().getId().replaceAll("-", "").toLowerCase(Locale.ENGLISH);
                hostnames.put(this.toRecordType(dnsZone.accessType()), DnsUtils.relativeSafeDnsName(recordName, subzone, dnsZone.name()));
                break;
            }
        }
        return hostnames;
    }

    @Override
    public String getPublicDNSZoneDomain(VirtualNetwork virtualNetwork) {
        String dnsName = "";
        DnsZone dnsZone = this.getDNSZone(virtualNetwork);
        if (dnsZone != null) {
            dnsName = dnsZone.name();
        }
        if (dnsName.endsWith(".")) {
            return dnsName.substring(0, dnsName.length() - 1);
        }
        return dnsName;
    }

    @Override
    public String getPrivateDNSZoneDomain(VirtualNetwork virtualNetwork) {
        return "";
    }

    public Optional<String> getDNSRecord(VirtualNetwork virtualNetwork, String recordName, DNSservice.RecordType recordType) {
        DnsZone dnsZone = this.getDNSZone(virtualNetwork);
        logger.info((Object)("DNS strategy: " + String.valueOf(virtualNetwork)));
        switch (virtualNetwork.getDnsStrategy()) {
            case VN_SPECIFIC_CLOUD_DNS_SERVICE: {
                return this.getDNSRecord(dnsZone, recordName, recordType);
            }
            case FM_MANAGED_CLOUD_DNS_SERVICE: {
                String subzone = virtualNetwork.getTenant().getId().replaceAll("-", "").toLowerCase(Locale.ENGLISH);
                return this.getDNSRecord(dnsZone, DnsUtils.relativeSafeDnsName(recordName, subzone), recordType);
            }
        }
        return Optional.empty();
    }

    @Override
    public void removeDNSRecord(VirtualNetwork virtualNetwork, PhysicalDNSRecord physicalDNSRecord) {
        if (physicalDNSRecord != null) {
            this.removeAzureDNSRecord(virtualNetwork, physicalDNSRecord.getName());
        }
    }

    @Override
    public void checkIfZoneExist(VirtualNetwork vn, String zoneId) {
        CloudAccount cloudAccount = vn.getCloudAccountOrVirtualCloudAccount();
        DnsZone dnsZone = (DnsZone)this.clientService.getAzureClient(cloudAccount).dnsZones().getById(zoneId);
        String azureSubscription = vn.getCloudAccountOrVirtualCloudAccount().getAzureSubscription();
        String azureRegion = vn.getAzureRegion();
        if (dnsZone == null) {
            throw new ApplicativeException("Invalid DNS Zone Identifier", "The DNS zone '" + zoneId + "' cannot be retrieved from subscription '" + azureSubscription + "' and region '" + azureRegion + "'.");
        }
    }

    public void removeAzureDNSRecord(VirtualNetwork virtualNetwork, String recordName) {
        if (virtualNetwork.getDnsStrategy() != VirtualNetwork.DNSStrategy.NONE) {
            DnsZone dnsZone = null;
            try {
                dnsZone = this.getDNSZone(virtualNetwork);
            }
            catch (ApplicativeException applicativeException) {
                // empty catch block
            }
            if (dnsZone != null) {
                DnsZone.Update update = (DnsZone.Update)dnsZone.update();
                update.withoutARecordSet(recordName);
                update.apply();
            }
        }
    }

    public DnsZone getDNSZone(VirtualNetwork virtualNetwork) throws ApplicativeException {
        if (virtualNetwork == null) {
            return null;
        }
        FMSettings settings = FMApp.getFMSettingsUnsafe();
        switch (virtualNetwork.getDnsStrategy()) {
            case VN_SPECIFIC_CLOUD_DNS_SERVICE: {
                CloudAccount cloudAccount = virtualNetwork.getCloudAccountOrVirtualCloudAccount();
                DnsZone zone = (DnsZone)this.clientService.getAzureClient(cloudAccount).dnsZones().getById(virtualNetwork.getAzureDnsZoneId());
                if (zone == null) {
                    throw new ApplicativeException("Invalid DNS Zone Identifier", "The DNS zone '" + virtualNetwork.getAzureDnsZoneId() + "' cannot be retrieved.");
                }
                return zone;
            }
            case FM_MANAGED_CLOUD_DNS_SERVICE: {
                DnsZone zone = (DnsZone)this.clientService.getAzureClient(virtualNetwork.getTenant().getVirtualCloudAccount(settings)).dnsZones().getById(settings.azureSettings.dnsZoneId);
                if (zone == null) {
                    throw new ApplicativeException("Invalid DNS Zone Identifier", "The DNS zone '" + settings.azureSettings.dnsZoneId + "' cannot be retrieved.");
                }
                return zone;
            }
        }
        return null;
    }

    private void addDNSRecord(DnsZone dnsZone, String recordName, String ipAddress, Map<String, String> tags) {
        logger.infoV("Writing DNS record zone=%s record=%s ip=%s", new Object[]{dnsZone.id(), recordName, ipAddress});
        DnsRecordSet.UpdateDefinitionStages.WithAttach updateWithAttach = ((DnsZone.Update)dnsZone.update()).defineARecordSet(recordName).withIPv4Address(ipAddress).withTimeToLive(60L);
        tags.forEach((arg_0, arg_1) -> ((DnsRecordSet.UpdateDefinitionStages.WithAttach)updateWithAttach).withMetadata(arg_0, arg_1));
        ((DnsZone.Update)updateWithAttach.attach()).apply();
    }

    private Optional<String> getDNSRecord(DnsZone dnsZone, String recordName, DNSservice.RecordType recordType) {
        logger.infoV("Get DNS record zone=%s record=%s", new Object[]{dnsZone.id(), recordName});
        return dnsZone.aRecordSets().list().stream().filter(r -> r.name().equals(recordName.toLowerCase())).filter(r -> r.recordType().toString().equals(recordType.name())).findFirst().flatMap(r -> r.ipv4Addresses().stream().findFirst());
    }

    public Map<String, ARecordSet> getDNSRecordPerLoadBalancerHostname(VirtualNetwork virtualNetwork) {
        DnsZone dnsZone = this.getDNSZone(virtualNetwork);
        logger.infoV("Get load balancer DNS records zone=%s", new Object[]{dnsZone.id()});
        return dnsZone.aRecordSets().list().stream().filter(record -> record.metadata().getOrDefault("Name", "").startsWith("FM-managed.for-hostname.")).collect(Collectors.toMap(record -> ((String)record.metadata().get("Name")).substring("FM-managed.for-hostname.".length()), record -> record));
    }

    private DNSservice.ZoneType toRecordType(ZoneType zoneType) {
        switch (zoneType) {
            case PUBLIC: {
                return DNSservice.ZoneType.PUBLIC;
            }
            case PRIVATE: {
                return DNSservice.ZoneType.PRIVATE;
            }
        }
        throw new IllegalStateException("Unknown zone type : '" + String.valueOf(zoneType) + "'");
    }
}

