/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.model.db;

import com.dataiku.dip.dao.DkuGroup;
import com.dataiku.dip.security.auth.UserSourceType;
import com.dataiku.fm.model.db.FMUser;
import com.dataiku.fm.model.db.Tenant;
import com.dataiku.fm.security.model.Permissions;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.SequenceGenerator;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

@Entity(name="fmgroup")
public class FMGroup
implements DkuGroup {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="fmgroup_sequence")
    @SequenceGenerator(name="fmgroup_sequence", sequenceName="fmgroup_sequence")
    private int id;
    @ManyToOne(fetch=FetchType.LAZY)
    private Tenant tenant;
    private String groupId;
    private boolean admin;
    private boolean write;
    private boolean read;
    @OneToMany(mappedBy="groups", fetch=FetchType.LAZY)
    private Set<FMUser> users = new HashSet<FMUser>();

    public Permissions toPermissions() {
        return new Permissions().withAdmin(this.admin).withRead(this.read).withWrite(this.write);
    }

    public int getId() {
        return this.id;
    }

    public void setId(int groupId) {
        this.id = groupId;
    }

    public Tenant getTenant() {
        return this.tenant;
    }

    public void setTenant(Tenant tenant) {
        this.tenant = tenant;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public void setAdmin(boolean admin) {
        this.admin = admin;
    }

    public boolean isWrite() {
        return this.write;
    }

    public void setWrite(boolean write) {
        this.write = write;
    }

    public boolean isRead() {
        return this.read;
    }

    public void setRead(boolean read) {
        this.read = read;
    }

    public Set<FMUser> getUsers() {
        return this.users;
    }

    public void setUsers(Set<FMUser> users) {
        this.users = users;
    }

    public Set<String> getExternalGroupNames() {
        return Collections.emptySet();
    }

    public UserSourceType getUserSourceType() {
        return UserSourceType.LOCAL;
    }

    public String getName() {
        return this.groupId;
    }

    public String getDescription() {
        return this.groupId;
    }
}

