/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.model.db;

import com.dataiku.dip.dao.DkuUser;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.security.auth.UserSourceType;
import com.dataiku.dip.util.PasswordUtils;
import com.dataiku.fm.model.db.FMGroup;
import com.dataiku.fm.model.db.FMPersonalAPIKey;
import com.dataiku.fm.model.db.FMUserSession;
import com.dataiku.fm.model.db.Tenant;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.SequenceGenerator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@Entity(name="fmuser")
public class FMUser
implements DkuUser {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="fmuser_sequence")
    @SequenceGenerator(name="fmuser_sequence", sequenceName="fmuser_sequence")
    private int id;
    @ManyToOne(fetch=FetchType.EAGER)
    private Tenant tenant;
    private UserSourceType sourceType = UserSourceType.LOCAL;
    private String emailAddress;
    private String displayName;
    private String passwordHash;
    private String createdBy;
    private long creationDate;
    @ManyToMany(cascade={CascadeType.ALL})
    @JoinTable(name="user_to_group", joinColumns={@JoinColumn(name="user_id")}, inverseJoinColumns={@JoinColumn(name="group_id")})
    private Set<FMGroup> groups = new HashSet<FMGroup>();
    @OneToMany(mappedBy="user", orphanRemoval=true, fetch=FetchType.LAZY)
    private Set<FMPersonalAPIKey> apiKeys;
    @OneToMany(mappedBy="user", orphanRemoval=true, fetch=FetchType.LAZY)
    private Set<FMUserSession> sessions;

    public FMUser() {
    }

    public int getId() {
        return this.id;
    }

    public FMUser(Tenant tenant, String email, String displayName) {
        this.tenant = tenant;
        this.setDisplayName(displayName);
        this.setEmailAddress(email);
        this.creationDate = System.currentTimeMillis();
    }

    public void setSecurePassword(String unencryptedPassword) {
        this.passwordHash = PasswordUtils.encryptPassword((String)unencryptedPassword);
    }

    public boolean verifyPassword(String unencryptedPassword) throws CodedException {
        if (this.passwordHash == null) {
            return false;
        }
        return PasswordUtils.verifyPassword((String)unencryptedPassword, (String)this.passwordHash);
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public Set<FMUserSession> getSessions() {
        return this.sessions;
    }

    public void setSessions(Set<FMUserSession> sessions) {
        this.sessions = sessions;
    }

    public String getLogin() {
        return this.emailAddress;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getEmail() {
        return this.emailAddress;
    }

    public void setEmail(String email) {
    }

    public String getUserProfile() {
        return "";
    }

    public void setUserProfile(String profile) {
    }

    public UserSourceType getUserSourceType() {
        if (this.sourceType == null) {
            this.sourceType = UserSourceType.LOCAL;
        }
        return this.sourceType;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public long getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(long creationDate) {
        this.creationDate = creationDate;
    }

    public Tenant getTenant() {
        return this.tenant;
    }

    public void setTenant(Tenant tenant) {
        this.tenant = tenant;
    }

    public List<String> getGroups() {
        return this.groups.stream().map(FMGroup::getName).collect(Collectors.toList());
    }

    public Set<FMGroup> getFMGroups() {
        return this.groups;
    }

    public void addGroupMembership(String group) {
    }

    public void removeGroupMembership(String group) {
    }

    public boolean isEnabled() {
        return true;
    }

    public void setEnabled(boolean enabled) {
    }

    public boolean isWelcomeEmailSent() {
        return false;
    }

    public void setGroups(Set<FMGroup> groups) {
        this.groups = groups;
    }

    public UserSourceType getSourceType() {
        if (this.sourceType == null) {
            this.sourceType = UserSourceType.LOCAL;
        }
        return this.sourceType;
    }

    public void setSourceType(UserSourceType sourceType) {
        this.sourceType = sourceType;
    }

    public String toString() {
        return "FMUser{tenant=" + String.valueOf(this.tenant) + ", sourceType=" + String.valueOf(this.sourceType) + ", emailAddress='" + this.emailAddress + "', displayName='" + this.displayName + "', createdBy='" + this.createdBy + "', creationDate=" + this.creationDate + "}";
    }
}

