/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.security;

import com.dataiku.common.server.APIKeyBase;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.fm.model.db.FMGroup;
import com.dataiku.fm.model.db.FMUser;
import com.dataiku.fm.security.model.ConfigurableFMPublicAPIKey;
import com.dataiku.fm.security.model.Permissions;
import com.dataiku.fm.security.model.PersonalFMPublicAPIKey;
import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import java.util.List;

public class FMAuthCtx
extends AuthCtx {
    private Permissions permissions;
    private String tenantId;

    private FMAuthCtx(AuthCtx.AuthSource authSource) {
        super(authSource);
    }

    public FMAuthCtx() {
    }

    public FMAuthCtx(FMAuthCtx authCtx) {
        super((AuthCtx)authCtx);
        this.tenantId = authCtx.tenantId;
        this.permissions = authCtx.permissions != null ? authCtx.permissions.deepCopy() : null;
    }

    public FMAuthCtx deepCopy() {
        return new FMAuthCtx(this);
    }

    public AuthCtx refresh() {
        throw new NotImplementedException();
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public static FMAuthCtx newNone() {
        return new FMAuthCtx(AuthCtx.AuthSource.NONE);
    }

    public static FMAuthCtx forUserFromUI(FMUser user, String accessToken) {
        FMAuthCtx authCtx = new FMAuthCtx(AuthCtx.AuthSource.USER_FROM_UI);
        authCtx.realUserLogin = user.getEmailAddress();
        authCtx.userAccessToken = accessToken;
        authCtx.tenantId = user.getTenant().getId();
        authCtx.permissions = new Permissions();
        for (FMGroup group : user.getFMGroups()) {
            authCtx.permissions = authCtx.permissions.union(group.toPermissions());
        }
        return authCtx;
    }

    public static FMAuthCtx fakeForTests(String login) {
        FMAuthCtx authCtx = new FMAuthCtx(AuthCtx.AuthSource.USER_FROM_UI);
        authCtx.realUserLogin = login;
        authCtx.tenantId = "main";
        return authCtx;
    }

    public String getIdentifier() {
        switch (this.authSource) {
            case CONFIGURABLE_API_KEY_GLOBAL: 
            case CONFIGURABLE_API_KEY_PROJECT: {
                return "api:" + this.apiKey.id;
            }
            case NONE: {
                return "no:auth";
            }
            case PERSONAL_API_KEY: 
            case USER_FROM_UI: {
                return this.realUserLogin;
            }
        }
        throw new Error("unreachable");
    }

    public Permissions getPermissions() {
        assert (this.authSource != AuthCtx.AuthSource.NONE);
        assert (this.permissions != null);
        return this.permissions;
    }

    public String getAssociatedDSSUser() {
        throw new Error("unreachable");
    }

    public String getAssociatedDSSUserMand() throws DKUSecurityException {
        throw new Error("unreachable");
    }

    public String getAssociatedDSSUserMandNoExc() {
        throw new Error("unreachable");
    }

    public String getDSSUserForImpersonation() {
        throw new Error("unreachable");
    }

    public void failIfNoSafeCode(String reason) {
        throw new Error("unreachable");
    }

    public void failIfNoUnsafeCode(String reason) {
        throw new Error("unreachable");
    }

    public boolean isSafeCodeAllowed() {
        throw new Error("unreachable");
    }

    public boolean isUnsafeCodeAllowed() {
        throw new Error("unreachable");
    }

    public boolean isAdmin() {
        return true;
    }

    static {
        JSON.registerAdapter(FMAuthCtx.class, (Object)new JSON.Adapter<FMAuthCtx>(){

            public FMAuthCtx deserialize(JsonElement jsonElement, Type scriptType, JsonDeserializationContext jsonDeserializationContext) {
                JsonObject jsonObj = jsonElement.getAsJsonObject();
                AuthCtx.AuthSource authSrc = (AuthCtx.AuthSource)jsonDeserializationContext.deserialize(jsonObj.get("authSource"), AuthCtx.AuthSource.class);
                FMAuthCtx base = new FMAuthCtx(authSrc);
                base.realUserLogin = (String)jsonDeserializationContext.deserialize(jsonObj.get("realUserLogin"), String.class);
                base.permissions = (Permissions)jsonDeserializationContext.deserialize(jsonObj.get("permissions"), Permissions.class);
                base.via = (List)jsonDeserializationContext.deserialize(jsonObj.get("via"), JSON.StringList.class);
                base.parentUser = (String)jsonDeserializationContext.deserialize(jsonObj.get("parentUser"), String.class);
                switch (base.authSource) {
                    case PERSONAL_API_KEY: {
                        base.apiKey = (APIKeyBase)jsonDeserializationContext.deserialize(jsonObj.get("apiKey"), PersonalFMPublicAPIKey.class);
                        break;
                    }
                    case CONFIGURABLE_API_KEY_GLOBAL: {
                        base.apiKey = (APIKeyBase)jsonDeserializationContext.deserialize(jsonObj.get("apiKey"), ConfigurableFMPublicAPIKey.class);
                        break;
                    }
                }
                return base;
            }

            public JsonElement serialize(FMAuthCtx task, Type type, JsonSerializationContext ctx) {
                return new Gson().toJsonTree((Object)task);
            }
        });
    }
}

