/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.core;

import com.dataiku.common.server.APIError;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.license.License;
import com.dataiku.dip.license.LicenseStatusService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.utils.JSON;
import com.dataiku.fm.license.FMLicenseStatusService;
import com.dataiku.fm.model.published.CloudCredentialsDTO;
import com.dataiku.fm.model.published.CloudTagList;
import com.dataiku.fm.model.published.SublicenseDTO;
import com.dataiku.fm.model.settings.FMSettings;
import com.dataiku.fm.security.FMAuthCtx;
import com.dataiku.fm.server.FMApp;
import com.dataiku.fm.server.core.CloudDataSyncService;
import com.dataiku.fm.server.core.LicenseSyncService;
import com.dataiku.fm.server.core.TenantCredentialsService;
import com.dataiku.fm.server.db.DatabaseAccessService;
import com.dataiku.fm.server.instances.SublicenseCRUDService;
import com.dataiku.fm.server.licensing.CentralLicensingStatusService;
import com.dataiku.fm.server.security.FMPermissionsService;
import com.dataiku.fm.server.security.FMUIAuthService;
import com.dataiku.fm.server.settings.SettingsDAO;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class TenantSetupController
extends DIPInternalControllerBase {
    @Autowired
    private FMUIAuthService uiAuthService;
    @Autowired
    private FMPermissionsService permissionsService;
    @Autowired
    private TenantCredentialsService tenantCredentialService;
    @Autowired
    private LicenseSyncService licenseSyncService;
    @Autowired
    private FMLicenseStatusService licenseStatusService;
    @Autowired
    private CentralLicensingStatusService centralLicensingStatusService;
    @Autowired
    private SublicenseCRUDService sublicenseCRUDService;
    @Autowired
    private DatabaseAccessService dbService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private SettingsDAO settingsDAO;
    @Autowired
    private CloudDataSyncService cloudDataSyncService;
    private static Logger logger = Logger.getLogger((String)"dku.tenant-setup");

    @RequestMapping(value={"/api/ui/tenant/get-cloud-credentials"})
    public void getCloudCredentials(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        TenantSetupController.writeJSON((HttpServletResponse)resp, (Object)this.tenantCredentialService.getCloudCredentialsDTO(authCtx.getTenantId()));
    }

    @RequestMapping(value={"/api/ui/tenant/set-cloud-credentials"})
    public void setCloudCredentials(HttpServletRequest req, HttpServletResponse resp, @RequestParam String cloudCredentials) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        CloudCredentialsDTO dto = (CloudCredentialsDTO)JSON.parse((String)cloudCredentials, CloudCredentialsDTO.class);
        if (StringUtils.isNotBlank((String)dto.license)) {
            try {
                License license = (License)JSON.parse((String)dto.license, License.class);
                LicenseStatusService.LicensingStatus licensingStatus = this.licenseStatusService.getLicensingStatus(license);
                if (!licensingStatus.valid) {
                    logger.warn((Object)("License is invalid: " + licensingStatus.invalidMessage));
                    resp.setStatus(400);
                    resp.setContentType("application/json");
                    APIError ae = new APIError("Bad license", licensingStatus.invalidMessage);
                    resp.getWriter().write(JSON.json((Object)ae));
                    return;
                }
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to read license file", (Throwable)e);
                resp.setStatus(400);
                resp.setContentType("application/json");
                APIError ae = new APIError("Bad license", "Failed to parse license file. Please check logs.");
                resp.getWriter().write(JSON.json((Object)ae));
                return;
            }
        }
        TenantSetupController.writeJSON((HttpServletResponse)resp, (Object)this.tenantCredentialService.updateCloudCredentials(authCtx, authCtx.getTenantId(), dto));
    }

    @RequestMapping(value={"/api/ui/tenant/get-cloud-tags"})
    public void getCloudTags(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        TenantSetupController.writeJSON((HttpServletResponse)resp, (Object)this.tenantCredentialService.getCloudTags(authCtx.getTenantId()));
    }

    @RequestMapping(value={"/api/ui/tenant/set-cloud-tags"})
    public void setCloudTags(HttpServletRequest req, HttpServletResponse resp, @RequestParam String cloudTags) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        CloudTagList tags = (CloudTagList)JSON.parse((String)cloudTags, CloudTagList.class);
        this.tenantCredentialService.updateCloudTags(authCtx, authCtx.getTenantId(), tags);
    }

    @RequestMapping(value={"/api/ui/tenant/refresh-license"})
    public void refreshTenantLicense(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        this.licenseSyncService.forceImmediateRefresh(authCtx.getTenantId());
    }

    @RequestMapping(value={"/api/ui/tenant/get-licensing-status"})
    public void getLicensingStatus(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        boolean i = true;
        TenantSetupController.writeJSON((HttpServletResponse)resp, this.centralLicensingStatusService.getGlobalLicensingStatus(authCtx));
    }

    @RequestMapping(value={"/api/ui/tenant/get-licensing-summary"})
    public void getLicensingSummary(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        boolean i = true;
        TenantSetupController.writeJSON((HttpServletResponse)resp, (Object)this.centralLicensingStatusService.getGlobalLicensingSummary(authCtx.getTenantId()));
    }

    @RequestMapping(value={"/api/ui/tenant/sublicenses/list"})
    public void listSublicenses(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        TenantSetupController.writeJSON((HttpServletResponse)resp, this.sublicenseCRUDService.list(authCtx.getTenantId()));
    }

    @RequestMapping(value={"/api/ui/tenant/sublicenses/create"})
    public void createSublicense(HttpServletRequest req, HttpServletResponse resp, @RequestParam String sublicense) throws Exception {
        SublicenseDTO dto = (SublicenseDTO)JSON.parse((String)sublicense, SublicenseDTO.class);
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        TenantSetupController.writeJSON((HttpServletResponse)resp, (Object)this.sublicenseCRUDService.create(authCtx, authCtx.getTenantId(), dto));
    }

    @RequestMapping(value={"/api/ui/tenant/sublicenses/get"})
    public void getSublicense(HttpServletRequest req, HttpServletResponse resp, @RequestParam String sublicenseId) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        TenantSetupController.writeJSON((HttpServletResponse)resp, (Object)this.sublicenseCRUDService.get(authCtx.getTenantId(), sublicenseId));
    }

    @RequestMapping(value={"/api/ui/tenant/sublicenses/delete"}, method={RequestMethod.DELETE})
    public void deleteSublicense(HttpServletRequest req, HttpServletResponse resp, @RequestParam String sublicenseId) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        TenantSetupController.writeJSON((HttpServletResponse)resp, (Object)this.sublicenseCRUDService.delete(authCtx.getTenantId(), sublicenseId));
    }

    @RequestMapping(value={"/api/ui/tenant/sublicenses/save"})
    public void saveSublicense(HttpServletRequest req, HttpServletResponse resp, @RequestParam String sublicense) throws Exception {
        SublicenseDTO dto = (SublicenseDTO)JSON.parse((String)sublicense, SublicenseDTO.class);
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
            this.sublicenseCRUDService.update(authCtx, authCtx.getTenantId(), dto);
            rwt.commit();
        }
    }

    @RequestMapping(value={"/api/ui/tenant/get-proxy-settings"})
    public void getProxySettings(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        TenantSetupController.writeJSON((HttpServletResponse)resp, (Object)FMApp.getFMSettingsUnsafe().proxySettings);
    }

    @RequestMapping(value={"/api/ui/tenant/set-proxy-settings"}, method={RequestMethod.PUT})
    public void setProxySettings(HttpServletRequest req, HttpServletResponse resp, @RequestParam String proxySettings) throws Exception {
        FMSettings fmSettings;
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser((AuthCtx)authCtx);){
            fmSettings = this.settingsDAO.read();
            fmSettings.proxySettings = (ProxySettings)JSON.parse((String)proxySettings, ProxySettings.class);
            this.settingsDAO.save(fmSettings);
            t.commit("Save settings.json");
        }
        this.cloudDataSyncService.forceImmediateRefresh();
        TenantSetupController.writeJSON((HttpServletResponse)resp, (Object)fmSettings.proxySettings);
    }
}

