/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.utils;

import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class DKUCompletableFuture {
    private static final DKULogger logger = DKULogger.getLogger(DKUCompletableFuture.class);

    public static <ResponseType> List<ResponseType> collectResponses(List<CompletableFuture<ResponseType>> futures) throws Exception {
        if (futures.isEmpty()) {
            return new ArrayList();
        }
        CompletableFuture resultFuture = new CompletableFuture();
        AtomicInteger remaining = new AtomicInteger(futures.size());
        for (CompletableFuture<ResponseType> future : futures) {
            future.whenComplete((r, e) -> {
                if (e != null) {
                    resultFuture.completeExceptionally((Throwable)e);
                    return;
                }
                if (remaining.decrementAndGet() == 0) {
                    resultFuture.complete(futures.stream().map(CompletableFuture::join).collect(Collectors.toList()));
                }
            });
        }
        try {
            return (List)resultFuture.get();
        }
        catch (InterruptedException | ExecutionException e2) {
            for (CompletableFuture<ResponseType> future : futures) {
                future.cancel(true);
            }
            if (e2 instanceof ExecutionException && e2.getCause() instanceof Exception) {
                throw (Exception)e2.getCause();
            }
            throw e2;
        }
    }

    public static <ResponseType> ResponseType collectResponse(CompletableFuture<ResponseType> future) throws Exception {
        return DKUCompletableFuture.collectResponses(List.of(future)).get(0);
    }

    public static <ResponseType> List<ResponseType> collectResponsesNoException(List<CompletableFuture<ResponseType>> futures) {
        try {
            return DKUCompletableFuture.collectResponses(futures);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public static CompletableFuture<Void> runAsync(ExceptionUtils.ThrowingRunnable<?> runnable, Executor executor) {
        return DKUCompletableFuture.callAsync(() -> {
            runnable.run();
            return null;
        }, executor);
    }

    public static <T> CompletableFuture<T> callAsync(Callable<T> callable, Executor executor) {
        CompletableFuture future = new CompletableFuture();
        CompletableFuture.runAsync(() -> {
            try {
                Object result = callable.call();
                future.complete(result);
            }
            catch (Throwable t) {
                future.completeExceptionally(t);
            }
        }, executor);
        return future;
    }

    public static class FutureCancellationTracker {
        private Set<CompletableFuture<?>> futures = new HashSet();
        private CancellationException exception = null;

        public synchronized <T> CompletableFuture<T> track(Supplier<CompletableFuture<T>> futureSupplier) {
            if (this.exception != null) {
                return CompletableFuture.failedFuture(this.exception);
            }
            CompletableFuture future = futureSupplier.get();
            this.futures.add(future);
            future.whenComplete((r, e) -> {
                FutureCancellationTracker futureCancellationTracker = this;
                synchronized (futureCancellationTracker) {
                    if (this.exception == null) {
                        this.futures.remove(future);
                    }
                }
            });
            return future;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancelAll(String message) {
            FutureCancellationTracker futureCancellationTracker = this;
            synchronized (futureCancellationTracker) {
                if (this.exception != null) {
                    return;
                }
                this.exception = new CancellationException(message);
            }
            try {
                for (CompletableFuture completableFuture : this.futures) {
                    completableFuture.completeExceptionally(this.exception);
                }
            }
            finally {
                this.futures = null;
            }
        }
    }
}

