(function(){
    'use strict';

    const app = angular.module('dataiku.dashboards');

    /**
     * Was previously located here: src/main/platypus/static/dataiku/js/dashboards/view.js
     */
    app.controller('InsightTileTemplateController', function($scope, TileLoadingState) {
        $scope.getInsightTypeClass = function() {
            const tile = $scope.tile;
            return (tile.tileParams && tile.tileParams.viewKind === 'SEARCH') ? 'dataset_table_search' : tile.insightType;
        };

        $scope.isCredentialError = function() {
            return $scope.error && $scope.error.code && ($scope.error.code==='ERR_CONNECTION_OAUTH2_REFRESH_TOKEN_FLOW_FAIL' || $scope.error.code==='ERR_CONNECTION_NO_CREDENTIALS');
        };

        $scope.manualLoad = function() {
            $scope.hook.loadStates[$scope.tile.$tileId] = TileLoadingState.WAITING;
            $scope.load();
        };
    });
})();
