(function() {
    'use strict';
    const app = angular.module('dataiku.recipes');

    app.controller("EmbedDocumentsRecipeCreationController", function($scope, Fn, $stateParams, DataikuAPI, $q,Dialogs, WT1, $controller, RecipeComputablesService, Logger, SmartId, RetrievableKnowledgeUtils, $rootScope) {

        $controller("_RecipeCreationControllerBase", {$scope:$scope});
        $controller("_RecipeOutputNewManagedBehavior", {$scope:$scope});

        $scope.recipeType = "embed_documents";

        $scope.recipeName = {};
        $scope.creationSettings = {
            VLMId : null,
            embeddingLLMId : null,
            vectorStoreType: 'CHROMA',
            connection: null,
            indexName: null,
            pineconeIndexName: null,
            zone: null,
            outputRetrievableKnowledgeName: null
        
        };
        $scope.recipe = {
            type: $scope.recipeType,
            projectKey: $stateParams.projectKey,
            inputs: {
                main: {
                    items: []
                },
                metadata_dataset: {
                    items: []
                }
            },
            
            name: "compute_" + $scope.creationSettings.outputRetrievableKnowledgeName,
        };


        function makeMainRole(refs) {
            return {
                main: {
                    items: refs.filter(function(ref) {return !!ref;}).map(function(ref) { return {ref}; }),
                }
            };
        }
        // Creates the recipe object and sends it to the backend
        $scope.doCreateRecipe = function() {
            // make sure recipe is up to date with latest names:
            $scope.recipe.inputs = $scope.recipe && $scope.recipe.inputs ? $scope.recipe.inputs : makeMainRole([$scope.io.inputFolder]);
            $scope.recipe.name = "compute_" + $scope.creationSettings.outputRetrievableKnowledgeName;
            
            const recipe = angular.copy($scope.recipe);
            const settings = angular.copy($scope.creationSettings);
            if ($scope.zone) {
                settings.zone = $scope.zone;
            }
            return DataikuAPI.flow.recipes.generic.create(recipe, settings);
        };

        $scope.$watchCollection('recipe.inputs.main.items', function (inputs) {
            // when creating the recipe without a preselected folder (+recipe from flow) $scope.io.inputFolder is not set. 
            if (inputs && inputs.length && $scope.computablesMap) {
                const folderId = inputs[0].ref;
                $scope.io.inputFolder = {smartName: folderId, name: $scope.computablesMap[folderId] && $scope.computablesMap[folderId].label};

                DataikuAPI.flow.zones.getZoneId($stateParams.projectKey, {id: folderId, type: "MANAGED_FOLDER", projectKey: $stateParams.projectKey}).success(function(zone) {
                    $scope.zone = zone.id;
                }).error(setErrorInScope.bind($scope));
            }
        })

        $scope.showOutputPane = function() {
            return !!$scope.io.inputFolder;
        };

        $scope.formIsValid = function() { // todo @claire: return formInvalidreason instead?
            const creationSettings = $scope.creationSettings;
            if(!creationSettings.outputRetrievableKnowledgeName){
                return false;
            }

            if(!creationSettings.embeddingLLMId){
                return false;
            }

            if(!creationSettings.vectorStoreType){
                return false;
            }

            if(RetrievableKnowledgeUtils.hasConnection(creationSettings) && !creationSettings.connection){
                return false;
            }

            return !(creationSettings.vectorStoreType === 'PINECONE' && !creationSettings.pineconeIndexName);


        };

        DataikuAPI.pretrainedModels.listAvailableLLMs($stateParams.projectKey, "TEXT_EMBEDDING_EXTRACTION").success(function(data){
            $scope.availableEmbeddingLLMs = data.identifiers;
            if ($scope.availableEmbeddingLLMs.length > 0) {
                $scope.creationSettings.embeddingLLMId = data.identifiers[0].id;
            }
        }).error(setErrorInScope.bind($scope));

        $scope.$on("preselectInputFolder", function(scope, preselectedInputFolder) {
            $scope.io.inputFolder = preselectedInputFolder;
            $scope.preselectedInputFolder = preselectedInputFolder;
        });

        $scope.$watch("io.inputFolder", function(nv) {
            if (!nv) return;

            if (nv.name && !$scope.creationSettings.outputRetrievableKnowledgeName) {
                const niceInputName = nv.name.replace(/[A-Z]*\./, "").replace(/[^\w-_]+/g, "").replaceAll(" ", "_");
                $scope.creationSettings.outputRetrievableKnowledgeName = niceInputName + "_embedded";
                $scope.recipe.name = "compute_" + $scope.creationSettings.outputRetrievableKnowledgeName;
            }
            if ($scope.preselectedInputFolder && $scope.io.inputFolder.smartName != $scope.preselectedInputFolder.smartName){
                $scope.zone = null;
            }
        });

        RecipeComputablesService.getComputablesMap($scope.recipe, $scope).then(function(map) {
            $scope.setComputablesMap(map);
        });
    });

    app.controller("EmbedDocumentsRecipeController", function($scope, $state, $rootScope, $q, $controller, $stateParams, DataikuAPI, RequestCenterService, EmbeddingUtils, 
    DOCUMENT_SPLITTING_METHOD_MAP, EMBED_DOCS_VECTOR_STORE_UPDATE_METHOD_MAP, VECTOR_STORE_TYPE_MAP, DatasetUtils, RecipesUtils, SmartId, WT1, ATSurveyService) {
        $controller("RAGEmbeddingRecipeEditionController", {$scope: $scope, VECTOR_STORE_UPDATE_METHOD_MAP: EMBED_DOCS_VECTOR_STORE_UPDATE_METHOD_MAP});
        $controller("_RecipeWithEngineBehavior", {$scope:$scope}); //Controller inheritance // for step status update

        DataikuAPI.flow.recipes.nlp.getDefaultEmbedDocumentRecipeSettings($stateParams.projectKey).success(function(data) {
            if (data && data.defaultVLMId) {
                $scope.adminDefaultVLMId = data.defaultVLMId; // admin has defined a default VLM to use on the instance
                $scope.setDefaultVLM();
            }
        }).error(setErrorInScope.bind($scope));
    
        DataikuAPI.pretrainedModels.listAvailableLLMs($stateParams.projectKey, "IMAGE_INPUT").success(function(data){
                $scope.availableVLMs = data.identifiers;
                $scope.setDefaultVLM();
        }).error(setErrorInScope.bind($scope))

        $scope.setDefaultVLM = function() {
            if(!$scope.recipe.params.defaultVlmId){
                if ($scope.adminDefaultVLMId && $scope.availableVLMs && $scope.availableVLMs.filter(x => x.id === $scope.adminDefaultVLMId).length > 0) {
                    $scope.recipe.params.defaultVlmId = $scope.adminDefaultVLMId;
                } else if ($scope.availableVLMs && $scope.availableVLMs.length > 0) {
                    $scope.recipe.params.defaultVlmId = $scope.availableVLMs[0].id;
                }
            }
        }
        
        $scope.EMBED_DOCS_EXTRACTION_MODES = [ // keep in sync with EmbedDocumentsRecipeParams.java - ExtractionMode enum
            {id: 'MANAGED_TEXT_ONLY', title: 'Text-only Extraction', description: "Extracts text from documents and uses headers to divide the content into meaningful extraction units. Supported file formats: PDF, DOCX, PPTX, HTML, TXT, MD."},
            {id: 'MANAGED_VISUAL_ONLY', title: 'Visual Extraction', description: "Uses a Vision Language Model (VLM) to extract information from documents that may include text and visual elements like charts, graphics, and tables. Supported file formats: PDF, DOC, DOCX, ODT, PPT, PPTX, ODP, JPG, JPEG, PNG, TXT, MD."},
            {id: 'CUSTOM_RULES', title: 'Custom rules', description: "Create your own rules for how text is extracted and choose which documents to apply them to. This gives you full control over the extraction process."},
        ];

        $scope.VLM_EXTRACTION_PROMPTS = {
            'SUMMARY_PROMPT': "Generate a concise summary, up to __DKU_NUMBER_OF_CHARS__ characters, derived from the screenshot(s) of document page(s) provided. \n"
                + "Begin with a brief overview and highlight crucial words, facts, or concepts to enhance both semantic and keyword searchability.\n"
                + "Omit any references to the original source.\n",

            'FULL_CONTENT_PROMPT': "Extract the information from the screenshot(s) of document page(s) provided at the end, maintaining the original text without alteration. Follow these guidelines:\n"
            + "* Use Markdown to format the text, including headers such as Title, Subtitle, and Main Sections, as well as any tables present in the document.\n"
            + "* Describe any images and charts within the document screenshot(s), as the visual content cannot be directly extracted.\n"
            + "* Exclude any hyperlinks, as they cannot be extracted from an image.\n"
            + "* Ensure the text content remains unchanged.\n"
            + "* Extract all text, including any footers or reference lists.\n",
        }

        $scope.getActiveVLMfromLLMid = function(vlmId){
            return $scope.availableVLMs.find(llm => llm.id === vlmId);
        }

        $scope.getPrompt = function(chunkSizeCharacters, promptVersion) {
            return $scope.VLM_EXTRACTION_PROMPTS[promptVersion].replace("__DKU_NUMBER_OF_CHARS__", chunkSizeCharacters);
        }

        DatasetUtils.listDatasetsUsabilityForAny($stateParams.projectKey).success(data => {
            $scope.availableInputDatasets = data;
        }).error(setErrorInScope.bind($scope));


        $scope.recipe.params.rules = $scope.recipe.params.rules || [];  // shouldn't be needed as default rules are retrieved from the backend

        $scope.makeDefaultVLMSettings = function(rule){
            let chunkSize = $scope.defaultChunkSize
            // If we set the chunk size for a structure extraction rule, and then transform
            // it into a VLM rule, we want to keep the chunk size reflected in the summary
            // prompt.
            if (rule?.splittingSettings.chunkSizeCharacters) {
                chunkSize = rule.splittingSettings.chunkSizeCharacters;
            }
            return {
                "llmId" : $scope.recipe.params.defaultVlmId === "DSS_NO_SELECTION"? undefined: $scope.recipe.params.defaultVlmId,
                "splitUnit" : "PAGE",
                "customNbPages": 1,
                "customPagesOverlap": 0,
                "useCustomPrompt" : false,
                "customPrompt": $scope.getPrompt(chunkSize, "SUMMARY_PROMPT"),
            }
        }
        $scope.makeDefaultStructuredSettings = function(){
            return {
                "splitUnit": "SECTION",
                "maxSectionDepth": 6,
                "imageHandlingMode": "IGNORE",
                "ocrEngine": "AUTO",
                "ocrLanguages": "en",
            }
        }

        $scope.shouldClearKnowledgeBank = function() { // not needed but just in case
            return false;
        }

        $scope.addNewRule = function(){
            $scope.recipe.params.rules.push({
                "filter": {
                    "enabled": true,
                    "distinct": false,
                    "uiData": {
                        "mode": "||",
                        "conditions": [
                            {
                                "input": "file extension",
                                "operator": "== [string]i" // equals case insensitive
                            }
                        ]
                    }
                },
                
                "actionToPerform": "STRUCTURED",
                "structuredSettings" : $scope.makeDefaultStructuredSettings(),
                "splittingSettings": {
                    "chunkSizeCharacters": $scope.defaultChunkSize,
                    "chunkOverlapCharacters": $scope.defaultOverlapSize
                },
                "storeInMultimodalColumn": "FULL_CONTENT"
            });
            $scope.uiState.showAdvancedSettings.push(false);
        }
        $scope.onRuleActionChange = function(idx){
            var ruleToBeUpdated = idx == -1 ? $scope.recipe.params.allOtherRule: $scope.recipe.params.rules[idx];

            if (ruleToBeUpdated.actionToPerform == 'VLM'){
                ruleToBeUpdated.vlmSettings = ruleToBeUpdated.vlmSettings || $scope.makeDefaultVLMSettings(ruleToBeUpdated);
                ruleToBeUpdated.storeInMultimodalColumn = "IMAGES";
            }
            else if (ruleToBeUpdated.actionToPerform == 'STRUCTURED'){
                ruleToBeUpdated.structuredSettings = ruleToBeUpdated.structuredSettings || $scope.makeDefaultStructuredSettings();
                ruleToBeUpdated.storeInMultimodalColumn = "FULL_CONTENT";
            }
        }
        $scope.clearAll = function(){ // remove all rules except 'all other files' rule
            // eslint-disable-next-line for-direction
            for (var i=$scope.recipe.params.rules.length-1; i>=0; i--){
                $scope.removeRule(i);
            }
        }
       
        $scope.removeRule = function(idx){
            // only 'classic' (not 'allOtherFiles') rules can be deleted
            $scope.recipe.params.rules.splice(idx, 1);
            $scope.uiState.showAdvancedSettings.splice(idx, 1);
        }

        $scope.uiState = {
            currentStep: 'strategy',
            showAdvancedSettings: [],
            showAdvancedSettingsAllOtherFiles: false,
            selectAllMetadataColumns: true,
            requestSent: false,
        };

        void function (){ // to hide all advanced settings by default
            for (var i = 0; i < $scope.recipe.params.rules.length; i++) {
                $scope.uiState.showAdvancedSettings.push(false);
            }
        }();

        /******  recipe related *****/
        $scope.hooks.getPayloadData = function () {
            return angular.toJson($scope.desc);
        };
        const recipePayloadSave = $scope.hooks.save;
        $scope.hooks.save = function () {
            return recipePayloadSave().then(() => {
                WT1.event("embed-documents-save");
                ATSurveyService.updateCounter('EmbedDocumentsSave');
            })
        }

        $scope.hooks.updateRecipeStatus = function() {
            var deferred = $q.defer();
            var payload = $scope.hooks.getPayloadData();
            $scope.updateRecipeStatusBase(false, payload).then(function() {
                // $scope.recipeStatus should have been set by updateRecipeStatusBase
                if (!$scope.recipeStatus) return deferred.reject();
                deferred.resolve($scope.recipeStatus);
            });
            return deferred.promise;
        };
        $scope.hasAllRequiredOutputs = () => {
            if (!$scope.recipeStatus || !$scope.recipeStatus.output || $scope.recipeStatus.output.fatal) {
                return false;
            }
            return true;
        };

        $scope.showWarningOnDocumentExtractionCodeEnv = () => {
            if ($scope.recipeStatus?.strategy) {
                return $scope.recipeStatus.strategy.messages?.some(
                    msg => msg.code === "WARN_RECIPE_CODE_ENV_NOT_AVAILABLE"
                );
            }
            return false;
        }

        $scope.internalCodeEnvsHRef = function() {
            if ($scope.appConfig.isAutomation) {
                return $state.href("admin.codeenvs-automation.internal");
            } else {
                return $state.href("admin.codeenvs-design.internal");
            }
        }

        $scope.sendDocExtractionInternalCodeEnvRequest = function() {
            DataikuAPI.requests.createInternalCodeEnvRequest("INSTALL_CODE_ENV", "INTERNAL_document_extraction", "Please install document extraction internal code env", 'MANUAL').success(function(data){
                RequestCenterService.WT1Events.onRequestSent("CODE_ENV", null, "INTERNAL_document_extraction", "Please install document extraction internal code env", data.id);
            }).error(setErrorInScope.bind($scope));
            $scope.uiState.requestSent = true;
        }

        $scope.canChangeEngine = function(){
            return false;  // no need, there is a single DSS engine for now
        };

        $scope.updateMethodDisabledReason = function(method) {
            return ""; // no use case where we need to disable update methods for now
        };

        $scope.recipe.inputs["metadata_dataset"] = $scope.recipe.inputs["metadata_dataset"] || {items: []}; // shouldn't be needed?
        $scope.metadataDatasetColumns = undefined; // initialisation is done after loading the input dataset

        $scope.getAllColumnsNames = function() {
            if (!$scope.metadataDatasetColumns) return [];
            return $scope.metadataDatasetColumns.map(column => column.name);
        }

        $scope.getAvailableSecurityColumnsWithEmpty = function() {

            let availableOptions = $scope.getAllColumnsNames(); // todo : should we prevent selecting the path column? 
            availableOptions.unshift($scope.RESET_VALUE);
            return availableOptions;
        }

        $scope.removeMetadataDataset = function() {
            $scope.recipe.inputs["metadata_dataset"].items = [];
            $scope.metadataDatasetColumns = [];
            $scope.desc.filePathMetadataColumn = undefined;
            $scope.desc.securityTokensColumn = undefined;
        }

        $scope.getRemainingMetadataColumns = function() {
            if(!$scope.metadataDatasetColumns || $scope.metadataDatasetColumns.length === 0) return [];
            return $scope.metadataDatasetColumns.filter(column => column.name !== $scope.desc.filePathMetadataColumn && column.name !== $scope.desc.securityTokensColumn);
        }

        $scope.updateAllMetadataSelection = function(shouldToggleAllMetadataBoolean) {
            if (shouldToggleAllMetadataBoolean){ // when clicking on the label : we need to update the input value
                $scope.uiState.selectAllMetadataColumns = !$scope.uiState.selectAllMetadataColumns
            }
            $scope.metadataDatasetColumns.forEach(function(col) {
                col.selected = $scope.uiState.selectAllMetadataColumns;
            });
        }

        $scope.onSingleColumnSelectionChange = function() { // update 'all column' boolean if needed.
            let areAllColumnSelected = true;
            $scope.getRemainingMetadataColumns().forEach(function(col) {
                areAllColumnSelected = areAllColumnSelected && col.selected;
            });

            $scope.uiState.selectAllMetadataColumns = areAllColumnSelected;
        }

        $scope.clickedOnColumnName = function(colName) {
            const selectedColumn = $scope.metadataDatasetColumns.filter(col => col.name == colName)[0];
            selectedColumn.selected = !selectedColumn.selected;

            $scope.onSingleColumnSelectionChange();
        }

        const baseRuleSchema = {
            "columns": [
                {
                    "name": "file extension",
                    "type": "string",
                    "$$groupKey": ""
                },
                {
                    "name": "file name", // Used in EmbedDocumentsRule.java, keep in sync to keep the form clean at creation time.
                    "type": "string",
                    "$$groupKey": ""
                },
                {
                    "name": "file path",
                    "type": "string",
                    "$$groupKey": ""
                }
            ],
            "userModified": false
        };
        $scope.ruleSchema = undefined;
        $scope.updateRulesSchema = function(){
            let ruleSchema = angular.copy(baseRuleSchema);
            if($scope.metadataDatasetColumns && $scope.metadataDatasetColumns.length > 0){
                $scope.metadataDatasetColumns.forEach(function(col) {
                    ruleSchema.columns.push({
                        "name": col.name,
                        "type": col.type,
                        "$$groupKey": 'Metadata dataset columns'
                    });
                });
            }
            
            $scope.ruleSchema = ruleSchema;
        }
        $scope.getRulesSchema = function() {
            return $scope.ruleSchema;
        }

        $scope.loadDatasetColumnsIfNeeded = function(resetSelection){
            if (!$scope.metadataDatasetRef) {
                $scope.metadataDatasetColumns = [];
                $scope.updateRulesSchema(); 
                return;
            }
    
            const resolvedRef = SmartId.resolve($scope.metadataDatasetRef, $stateParams.projectKey);
            DataikuAPI.datasets.get(resolvedRef.projectKey, resolvedRef.id, $stateParams.projectKey).then(response => {
                const schema = response.data.schema;

                if (resetSelection){
                    schema.columns.forEach(function(col) {
                        col.selected = true;
                    });
                    $scope.uiState.selectAllMetadataColumns = true;

                    $scope.desc.filePathMetadataColumn = schema.columns.map(col => col.name).indexOf("path") >= 0 ? "path": undefined; // if a column is named "path", select it by default
                    $scope.desc.securityTokensColumn = undefined;
                } else {
                    $scope.desc.filePathMetadataColumn = $scope.desc.filePathMetadataColumn || (schema.columns.map(col => col.name).indexOf("path") >= 0 ? "path": undefined);
                    schema.columns.forEach(function(col) {
                        col.selected = $scope.desc.userDefinedMetadataColumns.map(meta => meta.column).indexOf(col.name) >= 0;
                    });
                }
                $scope.metadataDatasetColumns = schema.columns;
                $scope.updateRulesSchema(); 
                $scope.onSingleColumnSelectionChange();
            });
        }

        $scope.$watch('recipe.inputs.metadata_dataset.items', function(nv, ov) {
            if (!nv) return;
            $scope.metadataDatasetRef = nv.length? nv[0].ref: undefined;
            let resetSelection;
            if (!$scope.metadataDatasetRef || !ov || ov.length != 1 || $scope.metadataDatasetRef !== ov[0].ref){
                resetSelection = true; // actual dataset change: reset the selection
            }
            else {
                resetSelection = false; // just reloading the page or opening the recipe, retrieve selection from desc
            }
            $scope.loadDatasetColumnsIfNeeded(resetSelection);
        }, true);

        
        $scope.$watch('metadataDatasetColumns', function(nv, ov) {
            if (!nv) return;
            $scope.desc.userDefinedMetadataColumns = $scope.getRemainingMetadataColumns().filter(column => column.selected).map(column => ({column: column.name}));
            
        }, true);

        $scope.createCustomRulesFrom = function(extractionMode){
            if ($scope.retrievableKnowledge && $scope.recipe.params){
                DataikuAPI.flow.recipes.nlp.getDefaultEmbedDocumentRules(extractionMode.id, $scope.retrievableKnowledge.embeddingLLMId, $scope.recipe.params.defaultVlmId, $stateParams.projectKey, $scope.recipe.params.defaultImageHandlingMode).success(function(data) {
                    if (data) { 
                        $scope.recipe.params.rules = data.rules;
                        Object.assign($scope.recipe.params.allOtherRule, data.allOtherRule); // only copy properties without changing reference
                        $scope.recipe.params.extractionMode = 'CUSTOM_RULES';
                    }
                }).error(setErrorInScope.bind($scope));
            }
        }
        $scope.isMetadataDatasetFilled = function(){
            return $scope.recipe.inputs['metadata_dataset'].items.length > 0;
        }

        $scope.overrideCustomPromptWith = function (rule, promptVersion) {
            if (promptVersion && $scope.VLM_EXTRACTION_PROMPTS[promptVersion]) {
                rule.vlmSettings.customPrompt = $scope.getPrompt(rule.splittingSettings.chunkSizeCharacters, promptVersion);
            }
        }

    });
 

})();
