#!/bin/bash -e
# Compile and install Python 3.9 on an Amazon Linux 2 system
# Compile against OpenSSL 1.1 because urllib3 now requires it

PYTHON_VERSION="3.9.23"
PYTHON_MD5="e6c3c5ba679cc6a1e2932b2fdcafbc3d"

# Check environment
source /etc/os-release
[ "$ID" = "amzn" -a "$VERSION_ID" = 2 ] || {
	echo >&2 "*** ERROR : not an Amazon Linux 2 system"
	exit 1
}
[ $EUID -eq 0 ] || {
	echo >&2 "*** ERROR : should be run as root"
	exit 1
}

if rpm --quiet -q openssl-devel; then
	echo "+ Python compilation requires OpenSSL 1.1"
	echo "+ Removing package 'openssl-devel' which would conflict with mandatory 'openssl11-devel' dependency"
	yum -y remove openssl-devel
fi

echo "+ Installing Python build dependencies ..."
yum -y --setopt=group_package_types="mandatory" install \
  @development \
  bzip2-devel \
  gdbm-devel \
  libffi-devel \
  libuuid-devel \
  ncurses-devel \
  openssl11-devel \
  readline-devel \
  sqlite-devel \
  xz-devel \
  zlib-devel \

TMP_DIR=$(mktemp -d -p /root)
(
	cd "$TMP_DIR"

	echo "+ Downloading Python $PYTHON_VERSION source archive into $TMP_DIR ..."
	curl -OsS "https://www.python.org/ftp/python/$PYTHON_VERSION/Python-$PYTHON_VERSION.tgz"
	echo "$PYTHON_MD5 Python-$PYTHON_VERSION.tgz" | md5sum -c

	tar xf Python-"$PYTHON_VERSION".tgz

	echo "+ Compiling and installing to /usr/local ..."
	(
		cd Python-"$PYTHON_VERSION"
		./configure
		make -j 8
		make altinstall
	) >build-python.log

	echo "+ Updating built-in packages ..."
	/usr/local/bin/python3.9 -m pip install --upgrade pip setuptools >>build-python.log
)

echo "+ Cleaning up ..."
rm -rf "$TMP_DIR"

echo "+ Done"
