/*
 * Decompiled with CFR 0.152.
 */
package org.python;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Properties;
import java.util.Set;
import org.python.core.CodeFlag;

public class Version {
    public static String PY_VERSION;
    public static int PY_MAJOR_VERSION;
    public static int PY_MINOR_VERSION;
    public static int PY_MICRO_VERSION;
    public static int PY_RELEASE_LEVEL;
    public static int PY_RELEASE_SERIAL;
    public static String DATE;
    public static String TIME;
    private static String GIT_BRANCH;
    private static String GIT_TAG;
    private static String GIT_VERSION;
    private static final Collection<CodeFlag> defaultCodeFlags;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadProperties() {
        boolean loaded = false;
        String versionProperties = "/org/python/version.properties";
        InputStream in = Version.class.getResourceAsStream("/org/python/version.properties");
        if (in != null) {
            try {
                Properties properties = new Properties();
                properties.load(in);
                loaded = true;
                PY_VERSION = properties.getProperty("jython.version");
                PY_MAJOR_VERSION = Integer.valueOf(properties.getProperty("jython.major_version"));
                PY_MINOR_VERSION = Integer.valueOf(properties.getProperty("jython.minor_version"));
                PY_MICRO_VERSION = Integer.valueOf(properties.getProperty("jython.micro_version"));
                PY_RELEASE_LEVEL = Integer.valueOf(properties.getProperty("jython.release_level"));
                PY_RELEASE_SERIAL = Integer.valueOf(properties.getProperty("jython.release_serial"));
                DATE = properties.getProperty("jython.build.date");
                TIME = properties.getProperty("jython.build.time");
                GIT_BRANCH = properties.getProperty("jython.build.git_branch");
                GIT_TAG = properties.getProperty("jython.build.git_tag");
                GIT_VERSION = properties.getProperty("jython.build.git_version");
            }
            catch (IOException ioe) {
                System.err.println("There was a problem loading ".concat("/org/python/version.properties").concat(":"));
                ioe.printStackTrace();
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (!loaded) {
            throw new RuntimeException("unable to load ".concat("/org/python/version.properties"));
        }
    }

    public static String getGitVersion() {
        return GIT_VERSION;
    }

    public static String getGitIdentifier() {
        return "".equals(GIT_TAG) || "undefined".equals(GIT_TAG) ? GIT_BRANCH : GIT_TAG;
    }

    public static String getBuildInfo() {
        String revision = Version.getGitVersion();
        String sep = "".equals(revision) ? "" : ":";
        String gitId = Version.getGitIdentifier();
        return String.format("%s%s%s, %.20s, %.9s", gitId, sep, revision, DATE, TIME);
    }

    public static String getVM() {
        return String.format("[%s (%s)]", System.getProperty("java.vm.name"), System.getProperty("java.vm.vendor"));
    }

    public static String getVersion() {
        return String.format("%.80s (%.80s)\n%.80s", PY_VERSION, Version.getBuildInfo(), Version.getVM());
    }

    public static Set<CodeFlag> getDefaultCodeFlags() {
        return EnumSet.copyOf(defaultCodeFlags);
    }

    static {
        defaultCodeFlags = Arrays.asList(CodeFlag.CO_NESTED, CodeFlag.CO_GENERATOR_ALLOWED, CodeFlag.CO_FUTURE_WITH_STATEMENT);
        Version.loadProperties();
    }
}

