/*
 * Decompiled with CFR 0.152.
 */
package se.fishtank.css.selectors.dom;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Node;
import se.fishtank.css.selectors.NodeSelector;
import se.fishtank.css.selectors.NodeSelectorException;
import se.fishtank.css.selectors.Selector;
import se.fishtank.css.selectors.Specifier;
import se.fishtank.css.selectors.dom.internal.AttributeSpecifierChecker;
import se.fishtank.css.selectors.dom.internal.NodeTraversalChecker;
import se.fishtank.css.selectors.dom.internal.PseudoClassSpecifierChecker;
import se.fishtank.css.selectors.dom.internal.PseudoContainsSpecifierChecker;
import se.fishtank.css.selectors.dom.internal.PseudoNthSpecifierChecker;
import se.fishtank.css.selectors.dom.internal.TagChecker;
import se.fishtank.css.selectors.scanner.Scanner;
import se.fishtank.css.selectors.scanner.ScannerException;
import se.fishtank.css.selectors.specifier.AttributeSpecifier;
import se.fishtank.css.selectors.specifier.NegationSpecifier;
import se.fishtank.css.selectors.specifier.PseudoClassSpecifier;
import se.fishtank.css.selectors.specifier.PseudoContainsSpecifier;
import se.fishtank.css.selectors.specifier.PseudoNthSpecifier;
import se.fishtank.css.util.Assert;

public class DOMNodeSelector
implements NodeSelector<Node> {
    private final Node root;

    public DOMNodeSelector(Node root) {
        Assert.notNull(root, "root is null!");
        short nodeType = root.getNodeType();
        Assert.isTrue(nodeType == 9 || nodeType == 1, "root must be a document or element node!");
        this.root = root;
    }

    @Override
    public Node querySelector(String selectors) throws NodeSelectorException {
        Set<Node> result = this.querySelectorAll(selectors);
        if (result.isEmpty()) {
            return null;
        }
        return result.iterator().next();
    }

    @Override
    public Set<Node> querySelectorAll(String selectors) throws NodeSelectorException {
        List<List<Selector>> groups;
        Assert.notNull(selectors, "selectors is null!");
        try {
            Scanner scanner = new Scanner(selectors);
            groups = scanner.scan();
        }
        catch (ScannerException e) {
            throw new NodeSelectorException(e);
        }
        LinkedHashSet<Node> results = new LinkedHashSet<Node>();
        for (List<Selector> parts : groups) {
            Set<Node> result = this.check(parts);
            if (result.isEmpty()) continue;
            results.addAll(result);
        }
        return results;
    }

    private Set<Node> check(List<Selector> parts) throws NodeSelectorException {
        Set<Node> result = new LinkedHashSet<Node>();
        result.add(this.root);
        for (Selector selector : parts) {
            NodeTraversalChecker checker = new TagChecker(selector);
            result = ((NodeTraversalChecker)checker).check(result, this.root);
            if (!selector.hasSpecifiers()) continue;
            for (Specifier specifier : selector.getSpecifiers()) {
                switch (specifier.getType()) {
                    case ATTRIBUTE: {
                        checker = new AttributeSpecifierChecker((AttributeSpecifier)specifier);
                        break;
                    }
                    case PSEUDO: {
                        if (specifier instanceof PseudoClassSpecifier) {
                            checker = new PseudoClassSpecifierChecker((PseudoClassSpecifier)specifier);
                            break;
                        }
                        if (specifier instanceof PseudoNthSpecifier) {
                            checker = new PseudoNthSpecifierChecker((PseudoNthSpecifier)specifier);
                            break;
                        }
                        if (!(specifier instanceof PseudoContainsSpecifier)) break;
                        checker = new PseudoContainsSpecifierChecker((PseudoContainsSpecifier)specifier);
                        break;
                    }
                    case NEGATION: {
                        final Set<Node> negationNodes = this.checkNegationSpecifier((NegationSpecifier)specifier);
                        checker = new NodeTraversalChecker(){

                            @Override
                            public Set<Node> check(Set<Node> nodes, Node root) throws NodeSelectorException {
                                LinkedHashSet<Node> set = new LinkedHashSet<Node>(nodes);
                                set.removeAll(negationNodes);
                                return set;
                            }
                        };
                    }
                }
                if (!(result = ((NodeTraversalChecker)checker).check(result, this.root)).isEmpty()) continue;
                return result;
            }
        }
        return result;
    }

    private Set<Node> checkNegationSpecifier(NegationSpecifier specifier) throws NodeSelectorException {
        ArrayList<Selector> parts = new ArrayList<Selector>(1);
        parts.add(specifier.getSelector());
        return this.check(parts);
    }
}

