/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.internal.SdkInternalList;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.DescribeInstancesRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.Filter;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;

public class DescribeInstancesRequestMarshaller
implements Marshaller<Request<DescribeInstancesRequest>, DescribeInstancesRequest> {
    @Override
    public Request<DescribeInstancesRequest> marshall(DescribeInstancesRequest describeInstancesRequest) {
        SdkInternalList describeInstancesRequestInstanceIdsList;
        if (describeInstancesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeInstancesRequest> request = new DefaultRequest<DescribeInstancesRequest>(describeInstancesRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeInstances");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeInstancesRequestFiltersList = (SdkInternalList)describeInstancesRequest.getFilters();
        if (!describeInstancesRequestFiltersList.isEmpty() || !describeInstancesRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeInstancesRequestFiltersListValue : describeInstancesRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeInstancesRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString(describeInstancesRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describeInstancesRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString(filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (!(describeInstancesRequestInstanceIdsList = (SdkInternalList)describeInstancesRequest.getInstanceIds()).isEmpty() || !describeInstancesRequestInstanceIdsList.isAutoConstruct()) {
            int instanceIdsListIndex = 1;
            for (String describeInstancesRequestInstanceIdsListValue : describeInstancesRequestInstanceIdsList) {
                if (describeInstancesRequestInstanceIdsListValue != null) {
                    request.addParameter("InstanceId." + instanceIdsListIndex, StringUtils.fromString(describeInstancesRequestInstanceIdsListValue));
                }
                ++instanceIdsListIndex;
            }
        }
        if (describeInstancesRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger(describeInstancesRequest.getMaxResults()));
        }
        if (describeInstancesRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeInstancesRequest.getNextToken()));
        }
        return request;
    }
}

