/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.LockSnapshotRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;

public class LockSnapshotRequestMarshaller
implements Marshaller<Request<LockSnapshotRequest>, LockSnapshotRequest> {
    @Override
    public Request<LockSnapshotRequest> marshall(LockSnapshotRequest lockSnapshotRequest) {
        if (lockSnapshotRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<LockSnapshotRequest> request = new DefaultRequest<LockSnapshotRequest>(lockSnapshotRequest, "AmazonEC2");
        request.addParameter("Action", "LockSnapshot");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (lockSnapshotRequest.getSnapshotId() != null) {
            request.addParameter("SnapshotId", StringUtils.fromString(lockSnapshotRequest.getSnapshotId()));
        }
        if (lockSnapshotRequest.getLockMode() != null) {
            request.addParameter("LockMode", StringUtils.fromString(lockSnapshotRequest.getLockMode()));
        }
        if (lockSnapshotRequest.getCoolOffPeriod() != null) {
            request.addParameter("CoolOffPeriod", StringUtils.fromInteger(lockSnapshotRequest.getCoolOffPeriod()));
        }
        if (lockSnapshotRequest.getLockDuration() != null) {
            request.addParameter("LockDuration", StringUtils.fromInteger(lockSnapshotRequest.getLockDuration()));
        }
        if (lockSnapshotRequest.getExpirationDate() != null) {
            request.addParameter("ExpirationDate", StringUtils.fromDate(lockSnapshotRequest.getExpirationDate()));
        }
        return request;
    }
}

